/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wfs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.wfs.WFSServiceImpl;
import net.refractions.udig.catalog.wfs.internal.Messages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.v1_0_0.xml.WFSSchema;

class WFSServiceInfo
extends IServiceInfo {
    private final WFSServiceImpl wfsService;
    private WFSDataStore ds;

    WFSServiceInfo(WFSServiceImpl wfsServiceImpl, WFSDataStore resource) {
        this.wfsService = wfsServiceImpl;
        this.ds = resource;
        this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.catalog.internal.wfs", (String)"icons/obj16/wfs_obj.16");
    }

    public String getVersion() {
        return this.ds.getServiceVersion();
    }

    public String getAbstract() {
        return this.ds.getInfo().getDescription();
    }

    public Set<String> getKeywords() {
        return this.ds.getInfo().getKeywords();
    }

    public URI getSchema() {
        return WFSSchema.NAMESPACE;
    }

    public String getDescription() {
        return this.wfsService.getIdentifier().toString();
    }

    public URI getSource() {
        try {
            return this.wfsService.getIdentifier().toURI();
        }
        catch (URISyntaxException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    public String getTitle() {
        String title = this.ds.getInfo().getTitle();
        title = title == null ? (this.wfsService.getIdentifier() == null ? Messages.WFSServiceImpl_broken : this.wfsService.getIdentifier().toString()) : String.valueOf(title) + " (WFS " + this.ds.getInfo().getVersion() + ")";
        return title;
    }
}

