/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wfs;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.AbstractDataStoreServiceExtension;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.internal.wfs.WFSServiceImpl;
import net.refractions.udig.catalog.wfs.internal.Messages;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.wfs.WFSDataStoreFactory;

public class WFSServiceExtension
extends AbstractDataStoreServiceExtension
implements ServiceExtension {
    private static WFSDataStoreFactory wfsDSFactory;

    public static WFSDataStoreFactory getWFSDSFactory() {
        if (wfsDSFactory == null) {
            wfsDSFactory = new WFSDataStoreFactory();
        }
        return wfsDSFactory;
    }

    public IService createService(URL id, Map<String, Serializable> params) {
        if (params == null || !params.containsKey(WFSDataStoreFactory.URL.key)) {
            return null;
        }
        if (!params.containsKey(WFSDataStoreFactory.LENIENT.key)) {
            params.put(WFSDataStoreFactory.LENIENT.key, Boolean.valueOf(true));
        }
        if (!params.containsKey(WFSDataStoreFactory.TRY_GZIP.key)) {
            params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.valueOf(true));
        }
        if (id == null) {
            URL base = (URL)params.get(WFSDataStoreFactory.URL.key);
            if (base == null) {
                return null;
            }
            id = WFSDataStoreFactory.createGetCapabilitiesRequest((URL)base);
        }
        return new WFSServiceImpl(id, params);
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!WFSServiceExtension.isWFS(url)) {
            return null;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(WFSDataStoreFactory.URL.key, url);
        params.put(WFSDataStoreFactory.BUFFER_SIZE.key, Integer.valueOf(100));
        params.put(WFSDataStoreFactory.LENIENT.key, Boolean.valueOf(true));
        params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.valueOf(true));
        return params;
    }

    private static final boolean isWFS(URL url) {
        return WFSServiceExtension.processURL(url) == null;
    }

    protected String doOtherChecks(Map<String, Serializable> params) {
        return null;
    }

    protected DataStoreFactorySpi getDataStoreFactory() {
        return WFSServiceExtension.getWFSDSFactory();
    }

    public String reasonForFailure(URL url) {
        String result = WFSServiceExtension.processURL(url);
        if (result != null) {
            return result;
        }
        return this.reasonForFailure(this.createParams(url));
    }

    private static String processURL(URL url) {
        String PATH = url.getPath();
        String QUERY = url.getQuery();
        String PROTOCOL = url.getProtocol();
        if (PROTOCOL.indexOf("http") == -1) {
            return String.valueOf(Messages.WFSServiceExtension_protocol) + "'" + PROTOCOL + "'";
        }
        if (QUERY != null && QUERY.toUpperCase().indexOf("SERVICE=") != -1) {
            int indexOf = QUERY.toUpperCase().indexOf("SERVICE=");
            if (QUERY.toUpperCase().indexOf("SERVICE=WFS") == -1) {
                int endOfExp = QUERY.indexOf(38, indexOf);
                if (endOfExp == -1) {
                    endOfExp = QUERY.length();
                }
                if (endOfExp > indexOf + 8) {
                    return String.valueOf(Messages.WFSServiceExtension_badService) + QUERY.substring(indexOf + 8, endOfExp);
                }
                return String.valueOf(Messages.WFSServiceExtension_badService);
            }
        }
        if (PATH != null && PATH.toUpperCase().indexOf("GEOSERVER/WFS") != -1) {
            return null;
        }
        return null;
    }
}

