/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.wfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.TreeSet;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.internal.wfs.WFSGeoResourceImpl;
import net.refractions.udig.catalog.internal.wfs.WfsPlugin;
import net.refractions.udig.ui.graphics.Glyph;
import org.geotools.data.FeatureStore;
import org.geotools.data.ResourceInfo;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class WFSGeoResourceInfo
extends IGeoResourceInfo {
    private final WFSGeoResourceImpl wfsResource;
    CoordinateReferenceSystem crs;
    private boolean writable;

    WFSGeoResourceInfo(WFSGeoResourceImpl wfsGeoResourceImpl) throws IOException {
        SimpleFeatureType ft;
        ResourceInfo resourceInfo;
        block8: {
            this.crs = null;
            this.writable = false;
            this.wfsResource = wfsGeoResourceImpl;
            WFSDataStore ds = this.wfsResource.parent.getDS(null);
            SimpleFeatureSource featureSource = ds.getFeatureSource(this.wfsResource.typename);
            this.writable = featureSource instanceof FeatureStore;
            resourceInfo = featureSource.getInfo();
            ft = null;
            try {
                ft = ds.getSchema(this.wfsResource.typename);
            }
            catch (Exception crippled) {
                if (!WfsPlugin.getDefault().isDebugging()) break block8;
                crippled.printStackTrace();
            }
        }
        this.bounds = resourceInfo.getBounds();
        this.description = resourceInfo.getDescription();
        this.title = resourceInfo.getTitle();
        this.crs = resourceInfo.getCRS();
        if (this.crs == null && ft != null) {
            this.crs = ft.getCoordinateReferenceSystem();
        }
        this.name = this.wfsResource.typename;
        this.schema = resourceInfo.getSchema();
        if (this.schema == null) {
            try {
                this.schema = ft != null ? new URI(ft.getName().getNamespaceURI()) : this.wfsResource.parent.getID().toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                this.schema = null;
            }
        }
        TreeSet<String> tags = new TreeSet<String>();
        try {
            tags.addAll(resourceInfo.getKeywords());
        }
        catch (Throwable t) {
            WfsPlugin.trace("Could not retrieve keywords", t);
        }
        tags.addAll(Arrays.asList("wfs", this.wfsResource.typename));
        this.keywords = tags.toArray(new String[0]);
        this.icon = Glyph.icon((SimpleFeatureType)ft);
    }

    public CoordinateReferenceSystem getCRS() {
        if (this.crs != null) {
            return this.crs;
        }
        return super.getCRS();
    }

    public boolean isWritable() {
        return this.writable;
    }
}

