/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.project;

import java.io.File;
import java.util.List;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.ProjectRegistry;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExportSelectionPage
extends WizardPage {
    private DirectoryFieldEditor editor;
    private ComboFieldEditor project;
    private Project selectedProject;

    public ExportSelectionPage(String title, String description, ImageDescriptor pageIcon) {
        super("Export Selection Page", title, pageIcon);
        this.setDescription(description);
    }

    public void createControl(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        GridData fileSelectionData = new GridData(1808);
        fileSelectionArea.setLayoutData((Object)fileSelectionData);
        fileSelectionArea.setLayout((Layout)new GridLayout(1, false));
        this.createProjectEditor(fileSelectionArea);
        this.createFileEditor(fileSelectionArea);
        fileSelectionArea.moveAbove(null);
        this.setControl((Control)fileSelectionArea);
        this.setPageComplete(false);
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    private void createProjectEditor(Composite parent) {
        URI uri;
        ProjectRegistry registery = ProjectPlugin.getPlugin().getProjectRegistry();
        List list = registery.getProjects();
        String[][] projects = new String[list.size()][];
        int index = 0;
        for (Project project : list) {
            projects[index] = new String[]{project.getName(), project.getID().toString()};
            ++index;
        }
        if (this.getDialogSettings() != null && registery.getCurrentProject() != null && (uri = registery.getCurrentProject().getID()) != null) {
            String selected = uri.toFileString();
            this.getDialogSettings().put("projectSelect", selected);
        }
        Composite projectPanel = new Composite(parent, 0);
        projectPanel.setLayout((Layout)new GridLayout(1, false));
        projectPanel.setLayoutData((Object)new GridData(768));
        this.project = new ComboFieldEditor("projectSelect", Messages.ExportSelectionPage_Project, projects, projectPanel);
        this.project.setPage((DialogPage)this);
        this.project.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ExportSelectionPage.this.selectProject((String)event.getNewValue());
                ExportSelectionPage.this.check();
            }
        });
    }

    private void createFileEditor(Composite parent) {
        Composite filePanel = new Composite(parent, 0);
        filePanel.setLayout((Layout)new GridLayout(1, false));
        filePanel.setLayoutData((Object)new GridData(768));
        this.editor = new DirectoryFieldEditor("directorySelect", Messages.ExportSelectionPage_Destination, filePanel){
            {
                this.setValidateStrategy(0);
                this.setEmptyStringAllowed(false);
            }

            public boolean isValid() {
                File file = new File(this.getStringValue());
                if (file.isDirectory()) {
                    return true;
                }
                this.setErrorMessage(Messages.ExportSelectionPage_MissingDir);
                return false;
            }
        };
        this.editor.setPage((DialogPage)this);
        this.editor.getTextControl(filePanel).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportSelectionPage.this.check();
            }
        });
    }

    public void check() {
        if (!this.editor.isValid()) {
            this.setPageComplete(false);
            this.setMessage(this.editor.getErrorMessage(), 3);
            return;
        }
        if (this.getProject() == null) {
            this.setPageComplete(false);
            this.setErrorMessage(Messages.ExportSelectionPage_SelectProject);
            return;
        }
        this.setPageComplete(true);
        this.setMessage(Messages.ExportSelectionPage_ExportProject, 1);
    }

    public void selectProject(String uri) {
        ProjectRegistry registery = ProjectPlugin.getPlugin().getProjectRegistry();
        List list = registery.getProjects();
        for (Project project : list) {
            if (!uri.equals(project.getID().toString())) continue;
            this.selectedProject = project;
            return;
        }
        this.selectedProject = null;
    }

    public Project getProject() {
        return this.selectedProject;
    }

    public String getDestinationDirectory() {
        return this.editor.getStringValue();
    }
}

