/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.project;

import java.lang.reflect.InvocationTargetException;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.impl.MapImpl;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.wizard.export.project.ExportProjectUtils;
import net.refractions.udig.project.ui.wizard.export.project.ExportSelectionPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportProjectWizard
extends Wizard
implements IExportWizard,
IRunnableWithProgress {
    private String destinationDirectory = "";
    private IStructuredSelection selection;
    private ExportSelectionPage selectionPage;
    ImageDescriptor wizardPageIconDescriptor = ProjectUIPlugin.imageDescriptorFromPlugin((String)"net.refractions.udig.project.ui", (String)"icons/wizban/exportproject_wiz.png");

    public boolean performFinish() {
        this.destinationDirectory = this.selectionPage.getDestinationDirectory();
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (Exception e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return true;
    }

    public boolean canFinish() {
        boolean canFinish = true;
        if (!this.selectionPage.isPageComplete()) {
            canFinish = false;
        }
        return canFinish;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.ExportProjectWizard_Title);
        this.setNeedsProgressMonitor(true);
        this.selectionPage = new ExportSelectionPage(Messages.ExportSelectionPage_Destination, Messages.ExportProjectWizard_Destination2, this.wizardPageIconDescriptor);
        Object selectionObj = selection.getFirstElement();
        IProject project = null;
        if (selectionObj instanceof MapImpl) {
            MapImpl map = (MapImpl)selectionObj;
            project = map.getProject();
        }
        if (selectionObj instanceof IProject) {
            project = (IProject)selectionObj;
        }
        if (project != null) {
            this.selectionPage.selectProject(project.getID().toString());
        }
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Project project = this.selectionPage.getProject();
        ExportProjectUtils.exportProject(project, this.destinationDirectory, monitor);
    }
}

