/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.resources.XMath;

public class XAffineTransform
extends AffineTransform {
    public static final double EPS = 1.0E-6;

    protected XAffineTransform(AffineTransform tr) {
        super(tr);
    }

    protected void checkPermission() {
    }

    @Override
    public void translate(double tx, double ty) {
        this.checkPermission();
        super.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.checkPermission();
        super.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.checkPermission();
        super.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.checkPermission();
        super.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.checkPermission();
        super.shear(shx, shy);
    }

    @Override
    public void setToIdentity() {
        this.checkPermission();
        super.setToIdentity();
    }

    @Override
    public void setToTranslation(double tx, double ty) {
        this.checkPermission();
        super.setToTranslation(tx, ty);
    }

    @Override
    public void setToRotation(double theta) {
        this.checkPermission();
        super.setToRotation(theta);
    }

    @Override
    public void setToRotation(double theta, double x, double y) {
        this.checkPermission();
        super.setToRotation(theta, x, y);
    }

    @Override
    public void setToScale(double sx, double sy) {
        this.checkPermission();
        super.setToScale(sx, sy);
    }

    @Override
    public void setToShear(double shx, double shy) {
        this.checkPermission();
        super.setToShear(shx, shy);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.checkPermission();
        super.setTransform(Tx);
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.checkPermission();
        super.setTransform(m00, m10, m01, m11, m02, m12);
    }

    @Override
    public void concatenate(AffineTransform Tx) {
        this.checkPermission();
        super.concatenate(Tx);
    }

    @Override
    public void preConcatenate(AffineTransform Tx) {
        this.checkPermission();
        super.preConcatenate(Tx);
    }

    public boolean isIdentity(double tolerance) {
        return XAffineTransform.isIdentity(this, tolerance);
    }

    public static boolean isIdentity(AffineTransform tr, double tolerance) {
        if (tr.isIdentity()) {
            return true;
        }
        tolerance = Math.abs(tolerance);
        return Math.abs(tr.getScaleX() - 1.0) <= tolerance && Math.abs(tr.getScaleY() - 1.0) <= tolerance && Math.abs(tr.getShearX()) <= tolerance && Math.abs(tr.getShearY()) <= tolerance && Math.abs(tr.getTranslateX()) <= tolerance && Math.abs(tr.getTranslateY()) <= tolerance;
    }

    public static Rectangle2D transform(AffineTransform transform, Rectangle2D bounds, Rectangle2D dest) {
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        int i = 0;
        while (i < 4) {
            point.x = (i & 1) == 0 ? bounds.getMinX() : bounds.getMaxX();
            point.y = (i & 2) == 0 ? bounds.getMinY() : bounds.getMaxY();
            transform.transform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (point.y > ymax) {
                ymax = point.y;
            }
            ++i;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public static Rectangle2D inverseTransform(AffineTransform transform, Rectangle2D bounds, Rectangle2D dest) throws NoninvertibleTransformException {
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        int i = 0;
        while (i < 4) {
            point.x = (i & 1) == 0 ? bounds.getMinX() : bounds.getMaxX();
            point.y = (i & 2) == 0 ? bounds.getMinY() : bounds.getMaxY();
            transform.inverseTransform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (point.y > ymax) {
                ymax = point.y;
            }
            ++i;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }

    public static Point2D inverseDeltaTransform(AffineTransform transform, Point2D source, Point2D dest) throws NoninvertibleTransformException {
        double m10;
        double m01;
        double m11;
        double m00 = transform.getScaleX();
        double det = m00 * (m11 = transform.getScaleY()) - (m01 = transform.getShearX()) * (m10 = transform.getShearY());
        if (!(Math.abs(det) > Double.MIN_VALUE)) {
            return transform.createInverse().deltaTransform(source, dest);
        }
        double x0 = source.getX();
        double y0 = source.getY();
        double x = (x0 * m11 - y0 * m01) / det;
        double y = (y0 * m00 - x0 * m10) / det;
        if (dest != null) {
            dest.setLocation(x, y);
            return dest;
        }
        return new Point2D.Double(x, y);
    }

    public static int getSwapXY(AffineTransform tr) {
        int flip = XAffineTransform.getFlip(tr);
        if (flip != 0) {
            double scaleX = XAffineTransform.getScaleX0(tr);
            double scaleY = XAffineTransform.getScaleY0(tr) * (double)flip;
            double y = Math.abs(tr.getShearY() / scaleY - tr.getShearX() / scaleX);
            double x = Math.abs(tr.getScaleY() / scaleY + tr.getScaleX() / scaleX);
            if (x > y) {
                return 1;
            }
            if (x < y) {
                return -1;
            }
        }
        return 0;
    }

    public static double getRotation(AffineTransform tr) {
        int flip = XAffineTransform.getFlip(tr);
        if (flip != 0) {
            double scaleX = XAffineTransform.getScaleX0(tr);
            double scaleY = XAffineTransform.getScaleY0(tr) * (double)flip;
            return Math.atan2(tr.getShearY() / scaleY - tr.getShearX() / scaleX, tr.getScaleY() / scaleY + tr.getScaleX() / scaleX);
        }
        return Double.NaN;
    }

    public static int getFlip(AffineTransform tr) {
        int scaleX = XMath.sgn((double)tr.getScaleX());
        int scaleY = XMath.sgn((double)tr.getScaleY());
        int shearX = XMath.sgn((double)tr.getShearX());
        int shearY = XMath.sgn((double)tr.getShearY());
        if (scaleX == scaleY && shearX == -shearY) {
            return 1;
        }
        if (scaleX == -scaleY && shearX == shearY) {
            return -1;
        }
        return 0;
    }

    public static double getScaleX0(AffineTransform tr) {
        return XMath.hypot((double)tr.getScaleX(), (double)tr.getShearX());
    }

    public static double getScaleY0(AffineTransform tr) {
        return XMath.hypot((double)tr.getScaleY(), (double)tr.getShearY());
    }

    public static double getScale(AffineTransform tr) {
        return 0.5 * (XAffineTransform.getScaleX0(tr) + XAffineTransform.getScaleY0(tr));
    }

    public static AffineTransform getScaleInstance(double sx, double sy, double x, double y) {
        return new AffineTransform(sx, 0.0, 0.0, sy, (1.0 - sx) * x, (1.0 - sy) * y);
    }

    public static void round(AffineTransform tr) {
        XAffineTransform.round(tr, 1.0E-6);
    }

    public static void round(AffineTransform tr, double tolerance) {
        double d;
        double r = tr.getScaleX();
        double m00 = Math.rint(r);
        if (Math.abs(d - r) <= tolerance) {
            double d2;
            r = tr.getShearX();
            double m01 = Math.rint(r);
            if (Math.abs(d2 - r) <= tolerance) {
                double d3;
                r = tr.getScaleY();
                double m11 = Math.rint(r);
                if (Math.abs(d3 - r) <= tolerance) {
                    double d4;
                    r = tr.getShearY();
                    double m10 = Math.rint(r);
                    if (!(!(Math.abs(d4 - r) <= tolerance) || m00 == 0.0 && m01 == 0.0 || m10 == 0.0 && m11 == 0.0)) {
                        double m12;
                        r = tr.getTranslateX();
                        double m02 = Math.rint(r);
                        if (!(Math.abs(m02 - r) <= tolerance)) {
                            m02 = r;
                        }
                        if (!(Math.abs((m12 = Math.rint(r = tr.getTranslateY())) - r) <= tolerance)) {
                            m12 = r;
                        }
                        tr.setTransform(m00, m10, m01, m11, m02, m12);
                    }
                }
            }
        }
    }
}

