/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import java.util.Collection;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.AdapterFactoryLabelProviderDecorator;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectExplorer;
import net.refractions.udig.project.ui.wizard.export.MapSelectorPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class MapSelectorPageWithScaleColumn
extends MapSelectorPage {
    private static final String SCALE = "EXPORT_SCALE";

    public MapSelectorPageWithScaleColumn(String page, String title, ImageDescriptor banner) {
        super(page, title, banner);
        this.setDescription(Messages.MapSelectorPageWithScaleColumn_Description);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        Button scale = new Button(comp, 8);
        scale.setText(Messages.MapSelectorPageWithScaleColumn_scale);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 1024;
        gridData.horizontalAlignment = 4;
        scale.setLayoutData((Object)gridData);
        scale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Collection<IMap> maps = MapSelectorPageWithScaleColumn.this.getMaps();
                for (IMap map : maps) {
                    map.getBlackboard().put(MapSelectorPageWithScaleColumn.SCALE, null);
                }
                MapSelectorPageWithScaleColumn.this.viewer.update(maps.toArray(), new String[]{MapSelectorPageWithScaleColumn.SCALE});
            }
        });
    }

    @Override
    protected void createColumns(Table table, TableLayout tableLayout) {
        super.createColumns(table, tableLayout);
        table.setHeaderVisible(true);
        this.createScaleColumn(table, tableLayout);
    }

    private void createScaleColumn(Table table, TableLayout tableLayout) {
        TableColumn column = new TableColumn(table, -1);
        column.setText(Messages.MapSelectorPageWithScaleColumn_scaleColumnText);
        column.setResizable(true);
        column.setAlignment(16384);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
    }

    @Override
    protected void configureEditors(final TableViewer viewer2) {
        final String message = Messages.MapSelectorPageWithScaleColumn_invalidScaleError;
        TextCellEditor textCellEditor = new TextCellEditor((Composite)viewer2.getTable());
        ICellEditorValidator validator = new ICellEditorValidator(){

            public String isValid(Object value) {
                MapSelectorPageWithScaleColumn.this.setErrorMessage(null);
                try {
                    int parseInt = Integer.parseInt((String)value);
                    if (parseInt < -1) {
                        return message;
                    }
                }
                catch (Exception exception) {
                    return message;
                }
                return null;
            }
        };
        textCellEditor.setValidator(validator);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = textCellEditor;
        viewer2.setCellEditors(cellEditorArray);
        viewer2.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals("scaleColumn");
            }

            public Object getValue(Object element, String property) {
                int scale2 = MapSelectorPageWithScaleColumn.getScaleDenom((IMap)element);
                return Integer.toString(scale2);
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                IMap map = (IMap)item.getData();
                try {
                    int parseInt = Integer.parseInt((String)value);
                    if (parseInt < -1) {
                        MapSelectorPageWithScaleColumn.this.setErrorMessage(message);
                    }
                    map.getBlackboard().putInteger(MapSelectorPageWithScaleColumn.SCALE, parseInt);
                    viewer2.update((Object)map, new String[]{MapSelectorPageWithScaleColumn.SCALE});
                    MapSelectorPageWithScaleColumn.this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    MapSelectorPageWithScaleColumn.this.setErrorMessage(message);
                    return;
                }
            }
        });
        viewer2.setColumnProperties(new String[]{"1", "scaleColumn"});
        ColumnViewerEditorActivationStrategy editorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer2);
        TableViewerEditor.create((TableViewer)viewer2, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)8);
    }

    @Override
    protected IBaseLabelProvider createLabelProvider(StructuredViewer viewer) {
        return new TableLabelProvider(new AdapterFactoryLabelProviderDecorator(ProjectExplorer.getProjectExplorer().getAdapterFactory(), viewer));
    }

    public static int getScaleDenom(IMap map) {
        Object scaleObject = map.getBlackboard().get(SCALE);
        int scale = scaleObject == null ? (int)map.getViewportModel().getScaleDenominator() : (Integer)scaleObject;
        return scale;
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final AdapterFactoryLabelProviderDecorator wrapped;

        public TableLabelProvider(AdapterFactoryLabelProviderDecorator wrapped) {
            this.wrapped = wrapped;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.wrapped.getImage(element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return this.wrapped.getText(element);
            }
            IMap map = (IMap)element;
            int scale = MapSelectorPageWithScaleColumn.getScaleDenom(map);
            if (scale == -1) {
                return Messages.MapSelectorPageWithScaleColumn_defaultScale;
            }
            return "1:" + scale;
        }

        public boolean isLabelProperty(Object element, String property) {
            return property.equals(MapSelectorPageWithScaleColumn.SCALE);
        }

        public void dispose() {
            this.wrapped.dispose();
        }
    }
}

