/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import net.refractions.udig.project.ui.SelectionStyle;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.wizard.export.image.ExportMapToImageWizard;
import net.refractions.udig.project.ui.wizard.export.image.GeotiffImageExportFormat;
import net.refractions.udig.project.ui.wizard.export.image.ImageExportFormat;
import net.refractions.udig.project.ui.wizard.export.image.PDFImageExportFormat;
import net.refractions.udig.project.ui.wizard.export.image.WorldImageExportFormat;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ImageExportPage
extends WizardPage {
    private Combo formatCombo;
    int currentFormatIndex;
    private Spinner width;
    private Spinner height;
    private Button baseHeightOnWidth;
    private Combo selectionCombo;
    private ArrayList<ImageExportFormat> formats;
    private Shell temporaryParent;
    private Composite formatConfiguration;

    public ImageExportPage() {
        super("Image Settings", Messages.ImageExportPage_ImageSettings, null);
        this.setDescription(Messages.ImageExportPage_ImageSettingsDescription);
    }

    public void createControl(Composite parent) {
        Composite top = this.createTopLevelComposite(parent, 1);
        Composite comp = this.createTopLevelComposite(top, 3);
        GridData gridData = new GridData(4, 0, true, false);
        comp.setLayoutData((Object)gridData);
        this.createFormatLabel(comp);
        this.createFormatCombo(comp);
        this.loadFormats();
        Composite sizeComposite = this.createTopLevelComposite(top, 5);
        gridData = new GridData(4, 0, true, false);
        sizeComposite.setLayoutData((Object)gridData);
        this.createWidthSpinner(sizeComposite);
        this.createHeightSpinner(sizeComposite);
        this.createCheckBox(sizeComposite);
        this.createSelectionHandling(comp);
        this.createFormatConfigurationComposite(top);
        this.selectPreferedFormat();
        this.setControl((Control)top);
    }

    private void createFormatConfigurationComposite(Composite top) {
        int maxWidth = -1;
        int maxHeight = -1;
        for (ImageExportFormat format : this.formats) {
            Point size = format.getControl().computeSize(-1, -1);
            if (maxWidth < size.x) {
                maxWidth = size.x;
            }
            if (maxHeight >= size.y) continue;
            maxHeight = size.y;
        }
        this.formatConfiguration = new Composite(top, 0);
        this.formatConfiguration.setLayout((Layout)new FillLayout());
        GridData gridData = new GridData(768);
        gridData.widthHint = maxWidth;
        gridData.heightHint = maxHeight;
        this.formatConfiguration.setLayoutData((Object)gridData);
    }

    private void loadFormats() {
        this.formats = new ArrayList();
        this.formats.addAll(this.loadImageWriterSpis());
        this.formats.add(new GeotiffImageExportFormat());
        this.formats.add(new PDFImageExportFormat());
        Collections.sort(this.formats, new Comparator<ImageExportFormat>(){

            @Override
            public int compare(ImageExportFormat format1, ImageExportFormat format2) {
                String name1 = format1.getName().toLowerCase();
                String name2 = format2.getName().toLowerCase();
                return name1.compareTo(name2);
            }
        });
        this.temporaryParent = new Shell();
        this.formatCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageExportPage.this.temporaryParent.dispose();
            }
        });
        for (ImageExportFormat format : this.formats) {
            format.createControl((Composite)this.temporaryParent);
            this.formatCombo.add(format.getName());
        }
    }

    private List<WorldImageExportFormat> loadImageWriterSpis() {
        IIORegistry defaultInstance = IIORegistry.getDefaultInstance();
        Iterator<ImageWriterSpi> writers = defaultInstance.getServiceProviders(ImageWriterSpi.class, false);
        ArrayList<WorldImageExportFormat> formats = new ArrayList<WorldImageExportFormat>();
        while (writers.hasNext()) {
            ImageWriterSpi writer = writers.next();
            formats.add(new WorldImageExportFormat(writer.getFormatNames()[0], writer.getFileSuffixes()[0]));
        }
        return formats;
    }

    private void createSelectionHandling(Composite top) {
        ImageExportPage.createLabel(top, Messages.ImageExportPage_Selection);
        this.selectionCombo = new Combo(top, 8);
        this.selectionCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.selectionCombo.setItems(new String[]{Messages.ImageExportPage_SelectionOverlay, Messages.ImageExportPage_SelectionOnly, Messages.ImageExportPage_SelectionIfAvailable, Messages.ImageExportPage_SelectionIgnore});
        this.selectionCombo.setData("0", (Object)SelectionStyle.OVERLAY);
        this.selectionCombo.setData("1", (Object)SelectionStyle.EXCLUSIVE);
        this.selectionCombo.setData("2", (Object)SelectionStyle.EXCLUSIVE_ALL);
        this.selectionCombo.setData("3", (Object)SelectionStyle.IGNORE);
        this.selectionCombo.select(0);
        String selection = this.getWizard().getDialogSettings().get("SELECTION_HANDLING");
        if (selection != null) {
            SelectionStyle saved = SelectionStyle.valueOf(selection);
            int i = 0;
            while (i < 4) {
                if (this.selectionCombo.getData(String.valueOf(i)) == saved) {
                    this.selectionCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    static void createLabel(Composite comp, String label) {
        Label scaleLabel = new Label(comp, 0);
        scaleLabel.setText(label);
        scaleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    public SelectionStyle getSelectionHandling() {
        SelectionStyle value = (SelectionStyle)this.selectionCombo.getData(String.valueOf(this.selectionCombo.getSelectionIndex()));
        this.getWizard().getDialogSettings().put("SELECTION_HANDLING", value.name());
        return value;
    }

    private void createCheckBox(Composite comp) {
        this.baseHeightOnWidth = new Button(comp, 32);
        this.baseHeightOnWidth.setText(Messages.ImageExportPage_AspectRatioCheck);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = 5;
        this.baseHeightOnWidth.setLayoutData((Object)layoutData);
        this.baseHeightOnWidth.setSelection(true);
        this.baseHeightOnWidth.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ImageExportPage.this.height.setEnabled(!ImageExportPage.this.baseHeightOnWidth.getSelection());
            }
        });
    }

    private void createHeightSpinner(Composite comp) {
        Label label = new Label(comp, 0);
        label.setText(Messages.ImageExportPage_ImageHeight);
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = 5;
        label.setLayoutData((Object)layoutData);
        this.height = new Spinner(comp, 2048);
        this.initSpinner(this.height, ExportMapToImageWizard.HEIGHT_KEY);
        this.height.setEnabled(false);
    }

    private void createWidthSpinner(Composite comp) {
        Label label = new Label(comp, 0);
        label.setText(Messages.ImageExportPage_ImageWidth);
        label.setLayoutData((Object)new GridData());
        this.width = new Spinner(comp, 2048);
        this.initSpinner(this.width, "widthKey");
    }

    private void initSpinner(Spinner spinner, String sizeKey) {
        spinner.setDigits(0);
        spinner.setIncrement(1);
        spinner.setPageIncrement(100);
        spinner.setMinimum(10);
        spinner.setMaximum(20000);
        String defaultSize = this.getWizard().getDialogSettings().get(sizeKey);
        if (defaultSize == null) {
            spinner.setSelection(1024);
        } else {
            spinner.setSelection(this.getWizard().getDialogSettings().getInt(sizeKey));
        }
        spinner.setLayoutData((Object)new GridData());
    }

    private Composite createTopLevelComposite(Composite parent, int columns) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        comp.setLayout((Layout)layout);
        return comp;
    }

    private void createFormatCombo(Composite comp) {
        this.formatCombo = new Combo(comp, 8);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.formatCombo.setLayoutData((Object)gridData);
        this.formatCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (ImageExportPage.this.currentFormatIndex != ImageExportPage.this.formatCombo.getSelectionIndex()) {
                    ImageExportFormat newFormat = ImageExportPage.this.getFormat();
                    ImageExportFormat previousFormat = (ImageExportFormat)ImageExportPage.this.formats.get(ImageExportPage.this.currentFormatIndex);
                    boolean useStandardDimensions = newFormat.useStandardDimensionControls();
                    ImageExportPage.this.baseHeightOnWidth.setEnabled(useStandardDimensions);
                    ImageExportPage.this.height.setEnabled(useStandardDimensions);
                    ImageExportPage.this.width.setEnabled(useStandardDimensions);
                    previousFormat.getControl().setParent((Composite)ImageExportPage.this.temporaryParent);
                    newFormat.getControl().setParent(ImageExportPage.this.formatConfiguration);
                    ImageExportPage.this.formatConfiguration.layout(true);
                }
                ImageExportPage.this.currentFormatIndex = ImageExportPage.this.formatCombo.getSelectionIndex();
            }
        });
    }

    private void selectPreferedFormat() {
        String preferedFormat = this.getWizard().getDialogSettings().get("exportFormatKey");
        if (preferedFormat == null) {
            preferedFormat = "png";
        }
        this.formatCombo.select(0);
        int index = 0;
        for (ImageExportFormat format : this.formats) {
            if (format.getExtension().equalsIgnoreCase(preferedFormat)) {
                this.formatCombo.select(index);
                break;
            }
            if (format.getExtension().equalsIgnoreCase("png")) {
                this.formatCombo.select(index);
            }
            ++index;
        }
    }

    private void createFormatLabel(Composite comp) {
        ImageExportPage.createLabel(comp, Messages.ImageExportPage_FormatLabel);
    }

    public ImageExportFormat getFormat() {
        return this.formats.get(this.formatCombo.getSelectionIndex());
    }

    public int getWidth(double mapwidth, double mapheight) {
        if (this.getFormat().useStandardDimensionControls()) {
            return this.width.getSelection();
        }
        return this.getFormat().getWidth(mapwidth, mapheight);
    }

    public int getHeight(double mapwidth, double mapheight) {
        int height = this.getFormat().useStandardDimensionControls() ? (this.baseHeightOnWidth.getSelection() ? (int)(mapheight / (mapwidth / (double)this.getWidth(mapwidth, mapheight))) : this.height.getSelection()) : this.getFormat().getHeight(mapwidth, mapheight);
        return height;
    }

    public boolean isPDF() {
        return this.getFormat() instanceof PDFImageExportFormat;
    }
}

