/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.refractions.udig.project.ui.wizard.export.image.Paper;

public class Image2Pdf {
    public static void write(BufferedImage image, String pdfPath, Paper paper, int widthBorder, int heightBorder, boolean landscape, int dpi) {
        Dimension printPageSize = null;
        printPageSize = new Dimension(paper.getPixelWidth(landscape, dpi), paper.getPixelHeight(landscape, dpi));
        Document document = new Document(new Rectangle((float)printPageSize.width, (float)printPageSize.height));
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(pdfPath));
            document.open();
            int w = printPageSize.width;
            int h = printPageSize.height;
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)w, (float)h);
            Graphics2D g2 = tp.createGraphics((float)w, (float)h);
            tp.setWidth((float)w);
            tp.setHeight((float)h);
            g2.drawImage(image, null, widthBorder, heightBorder);
            g2.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        document.close();
    }

    public static void main(String[] args) {
        String path = "/home/moovida/Desktop/screens/austrocontrol_2.png";
        BufferedImage b = null;
        try {
            b = ImageIO.read(new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Image2Pdf.write(b, String.valueOf(path) + ".pdf", Paper.A1, 10, 10, false, 100);
        System.out.println("finished");
    }
}

