/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.wizard.export.image.ImageExportFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;

public class GeotiffImageExportFormat
extends ImageExportFormat {
    @Override
    public String getExtension() {
        return "tif";
    }

    @Override
    public String getName() {
        return "Geotiff";
    }

    @Override
    public void createControl(Composite parent) {
        this.setControl((Control)new Composite(parent, 0));
    }

    @Override
    public void write(IMap map, BufferedImage image, File destination) throws IOException {
        GeoTiffWriter writer = new GeoTiffWriter((Object)destination);
        GridCoverage coverage = this.convertToGridCoverage(map.getViewportModel(), image);
        writer.write(coverage, null);
    }

    private GridCoverage convertToGridCoverage(IViewportModel viewportModel, BufferedImage image) {
        ReferencedEnvelope env = viewportModel.getBounds();
        GridCoverageFactory factory = new GridCoverageFactory();
        GridCoverage2D gc = factory.create((CharSequence)"GridCoverage", (RenderedImage)image, (Envelope)env);
        return gc;
    }
}

