/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.ui.AdapterFactoryLabelProviderDecorator;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectExplorer;
import net.refractions.udig.project.ui.wizard.export.AddMapsSelectionListener;
import net.refractions.udig.project.ui.wizard.export.ContentProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class MapSelectorPage
extends WizardPage {
    private Collection<IMap> maps = new HashSet<IMap>();
    protected StructuredViewer viewer;
    private Text destText;

    public MapSelectorPage(String page, String title, ImageDescriptor banner) {
        super(page, title != null ? title : Messages.MapSelectorPage_pageName, banner);
        this.setPageComplete(!this.getMaps().isEmpty());
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        comp.setLayout((Layout)layout);
        this.createExportLabel(comp);
        String tooltip = Messages.ImageExportPage_directoryToolTip;
        this.createExportText(comp, tooltip);
        this.createExportBrowseButton(comp, tooltip);
        this.createMapSelector(comp);
        this.setControl((Control)comp);
    }

    private void createExportBrowseButton(Composite comp, String tooltip) {
        Button browse = new Button(comp, 8);
        browse.setText(Messages.ImageExportPage_browse);
        browse.setToolTipText(tooltip);
        browse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browse.addSelectionListener((SelectionListener)new SelectButtonListener());
    }

    private void createExportText(Composite comp, String tooltip) {
        this.destText = new Text(comp, 2052);
        this.destText.setToolTipText(tooltip);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.destText.setLayoutData((Object)gridData);
        String previousLocation = this.getWizard().getDialogSettings().get("exportDirectoryKey");
        if (previousLocation != null) {
            this.destText.setText(previousLocation);
        } else {
            this.destText.setText(Platform.getLocation().toOSString());
        }
    }

    private void createExportLabel(Composite comp) {
        Label scaleLabel = new Label(comp, 0);
        scaleLabel.setText(Messages.ImageExportPage_exportLabelText);
        scaleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    public File getExportDir() {
        return new File(this.destText.getText());
    }

    private void createMapSelector(Composite listComp) {
        GridData layoutData = new GridData(4, 4, true, true);
        listComp.setLayoutData((Object)layoutData);
        listComp.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(listComp, 0);
        label.setText(Messages.MapSelectorPage_selectMapsLabel);
        layoutData = new GridData(4, 0, true, false);
        layoutData.horizontalSpan = 3;
        label.setLayoutData((Object)layoutData);
        this.initializeViewer(listComp);
        Button add = new Button(listComp, 8);
        add.setText(Messages.MapSelectorPage_Add);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new AddMapsSelectionListener(this));
        Button remove = new Button(listComp, 8);
        remove.setText(Messages.MapSelectorPage_Remove);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        remove.setLayoutData((Object)gridData);
        remove.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)MapSelectorPage.this.viewer.getSelection();
                for (IMap map : selection) {
                    MapSelectorPage.this.maps.remove(map);
                }
                MapSelectorPage.this.viewer.refresh(false);
            }
        });
    }

    protected final void initializeViewer(Composite listComp) {
        TableViewer tableViewer = new TableViewer(listComp, 67586);
        this.viewer = tableViewer;
        Table table = tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        this.createColumns(table, tableLayout);
        this.viewer.getControl().setToolTipText(Messages.MapSelectorPage_selectmapsExport);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        layoutData.verticalSpan = 3;
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.getControl().setLayoutData((Object)layoutData);
        this.viewer.setLabelProvider(this.createLabelProvider(this.viewer));
        this.viewer.setInput(this.maps);
        this.configureEditors(tableViewer);
    }

    protected void configureEditors(TableViewer viewer2) {
    }

    protected IBaseLabelProvider createLabelProvider(StructuredViewer viewer2) {
        return new AdapterFactoryLabelProviderDecorator(ProjectExplorer.getProjectExplorer().getAdapterFactory(), viewer2);
    }

    protected void createColumns(Table table, TableLayout tableLayout) {
        TableColumn column = new TableColumn(table, -1);
        column.setText(Messages.MapSelectorPage_mapNameColumnText);
        column.setResizable(true);
        column.setAlignment(16384);
    }

    public void updateMapList() {
        if (this.viewer != null) {
            this.viewer.refresh(false);
        }
    }

    public Collection<IMap> getMaps() {
        return this.maps;
    }

    public void setSelection(IStructuredSelection selection) {
        this.maps = new HashSet<IMap>();
        this.addToSelection(selection);
    }

    public void addToSelection(IStructuredSelection selection) {
        IMap activeMap;
        for (Object next : selection) {
            IMap map = this.cast(this.maps, next, IMap.class);
            if (map != null) {
                this.maps.add(map);
                continue;
            }
            IProject project = this.cast(this.maps, next, IProject.class);
            if (project == null) continue;
            this.maps.addAll(project.getElements(IMap.class));
        }
        if (this.maps.isEmpty() && (activeMap = ApplicationGIS.getActiveMap()) != ApplicationGIS.NO_MAP) {
            this.maps.add(activeMap);
        }
        this.updateMapList();
        this.setPageComplete(!this.maps.isEmpty());
    }

    private <T> T cast(Collection<IMap> maps, Object next, Class<T> mapClass) {
        IAdaptable adaptable;
        if (mapClass.isAssignableFrom(next.getClass())) {
            return mapClass.cast(next);
        }
        if (next instanceof IAdaptable && (adaptable = (IAdaptable)next).getAdapter(mapClass) != null) {
            return mapClass.cast(adaptable.getAdapter(mapClass));
        }
        return null;
    }

    public class SelectButtonListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DirectoryDialog d = new DirectoryDialog(e.widget.getDisplay().getActiveShell());
            String selection = d.open();
            if (selection != null) {
                MapSelectorPage.this.destText.setText(selection);
            }
        }
    }
}

