/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.wizard.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.ui.export.CatalogExport;
import net.refractions.udig.catalog.ui.export.Data;
import net.refractions.udig.catalog.ui.export.ExportResourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardAdapter;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ProgressManager;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.opengis.filter.Filter;

public class ExportFeatureSelection
extends CatalogExport {
    public WorkflowWizard getWizard() {
        return this.wizard;
    }

    protected Workflow createWorkflow() {
        ExportLayerSelectionState layerState = new ExportLayerSelectionState();
        Workflow workflow = new Workflow(new State[]{layerState});
        return workflow;
    }

    protected Map<Class<? extends State>, WorkflowWizardPageProvider> createPageMapping() {
        Map pageMapping = super.createPageMapping();
        WorkflowWizardPageProvider page = (WorkflowWizardPageProvider)pageMapping.get(ExportResourceSelectionState.class);
        pageMapping.put(ExportLayerSelectionState.class, page);
        return pageMapping;
    }

    private final class ExportLayerSelectionState
    extends ExportResourceSelectionState {
        private ExportLayerSelectionState() {
        }

        protected Object[] loadNonWorkbencSelection() {
            IMap activeMap = ApplicationGIS.getActiveMap();
            if (activeMap != ApplicationGIS.NO_MAP) {
                return new Object[]{activeMap};
            }
            return super.loadNonWorkbencSelection();
        }

        protected Collection<Data> convertToGeoResource(Object object) throws IOException {
            ArrayList<Data> data = new ArrayList<Data>();
            ILayer layer = (ILayer)AdapterUtil.instance.adaptTo(ILayer.class, object, ProgressManager.instance().get(new Object[0]));
            if (layer != null) {
                IGeoResource resource = layer.findGeoResource(FeatureSource.class);
                if (resource != null) {
                    Filter filter = layer.getFilter();
                    if (filter == Filter.EXCLUDE) {
                        filter = Filter.INCLUDE;
                    }
                    DefaultQuery query = new DefaultQuery(layer.getSchema().getTypeName(), filter);
                    Data data2 = new Data(resource, (Query)query);
                    data2.setChecked(layer.isVisible());
                    data.add(data2);
                }
            } else if (object instanceof IMap) {
                List mapLayers = ((IMap)object).getMapLayers();
                for (ILayer l : mapLayers) {
                    data.addAll(0, this.convertToGeoResource(l));
                }
            } else {
                return super.convertToGeoResource(object);
            }
            return data;
        }
    }

    public static class FeatureSelectionExportWizard
    extends WorkflowWizardAdapter {
        public FeatureSelectionExportWizard() {
            super(new ExportFeatureSelection().getWizard());
        }
    }
}

