/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.viewers;

import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.render.displayAdapter.IMapDisplayListener;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.RenderManagerDynamic;
import net.refractions.udig.project.ui.internal.TiledRenderManagerDynamic;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.ViewportPaneSWT;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.ViewportPaneTiledSWT;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MapViewer
implements MapPart {
    protected ViewportPane viewport;
    protected Map map;
    private IWorkbenchPart part;
    private Menu menu;
    private RenderManager renderManager;
    private double[] resolutions;
    private MapPart mapPart;

    public MapViewer(Composite parent) {
        this(parent, 0x20000002);
    }

    public MapViewer(Composite parent, int style) {
        this.viewport = (style & 2) == 2 ? new ViewportPaneTiledSWT(parent, style, this) : ((style & 4) == 4 ? new ViewportPaneSWT(parent, style, this) : new ViewportPaneSWT(parent, this));
    }

    public void init(IWorkbenchPart part) {
        this.part = part;
        this.mapPart = (MapPart)part;
    }

    public ViewportPane getViewport() {
        return this.viewport;
    }

    public Control getControl() {
        if (this.viewport instanceof Control) {
            return (Control)this.viewport;
        }
        return null;
    }

    public RenderManager getRenderManager() {
        return this.renderManager;
    }

    @Override
    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        if (this.map == map) {
            return;
        }
        if (this.map != null) {
            this.renderManager = this.map.getRenderManagerInternal();
            this.viewport.removePaneListener((IMapDisplayListener)this.map.getViewportModelInternal());
            this.renderManager.setMapInternal(null);
            this.renderManager.setMapDisplay(null);
            this.viewport.setRenderManager(null);
        }
        this.map = map;
        if (map.getRenderManager() == null) {
            if (this.viewport instanceof ViewportPaneTiledSWT) {
                map.setRenderManagerInternal((RenderManager)new TiledRenderManagerDynamic());
            } else {
                map.setRenderManagerInternal((RenderManager)new RenderManagerDynamic());
            }
        }
        this.renderManager = map.getRenderManagerInternal();
        this.viewport.setRenderManager(this.renderManager);
        this.renderManager.setMapDisplay((IMapDisplay)this.viewport);
        this.viewport.addPaneListener((IMapDisplayListener)map.getViewportModelInternal());
    }

    public void setMenu(Menu contextMenu) {
        this.menu = contextMenu;
    }

    public Menu getMenu() {
        return this.menu;
    }

    @Override
    public IStatusLineManager getStatusLineManager() {
        IWorkbenchPartSite site = this.part.getSite();
        if (site instanceof IViewSite) {
            IViewSite viewSite = (IViewSite)site;
            return viewSite.getActionBars().getStatusLineManager();
        }
        if (site instanceof IEditorSite) {
            IEditorSite editorSite = (IEditorSite)site;
            return editorSite.getActionBars().getStatusLineManager();
        }
        throw new NullPointerException("Unable to determine StatusLineManager");
    }

    @Override
    public void openContextMenu() {
        Menu contextMenu = this.getMenu();
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && contextMenu != null) {
            control.getDisplay().asyncExec(new Runnable((Widget)control, contextMenu){
                private final /* synthetic */ Widget val$control;
                private final /* synthetic */ Menu val$contextMenu;
                {
                    this.val$control = widget;
                    this.val$contextMenu = menu;
                }

                @Override
                public void run() {
                    if (this.val$control == null || this.val$control.isDisposed()) {
                        return;
                    }
                    this.val$contextMenu.setVisible(true);
                }
            });
        }
    }

    @Override
    public void setFont(Control control) {
        Display display = control.getDisplay();
        FontData[] data = display.getFontList("courier", true);
        if (data.length < 1) {
            data = control.getFont().getFontData();
        }
        int i = 0;
        while (i < data.length) {
            if ("macosx" == Platform.getOS()) {
                data[i].setHeight(12);
            } else {
                data[i].setHeight(10);
            }
            ++i;
        }
        control.setFont(new Font((Device)control.getDisplay(), data));
    }

    @Override
    public void setSelectionProvider(IMapEditorSelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            throw new NullPointerException("selection provider must not be null!");
        }
        selectionProvider.setActiveMap((IMap)this.map, this);
        if (this.part != null) {
            this.part.getSite().setSelectionProvider((ISelectionProvider)selectionProvider);
        }
    }

    public void dispose() {
        if (this.viewport != null && this.getMap() != null) {
            this.viewport.removePaneListener((IMapDisplayListener)this.getMap().getViewportModelInternal());
            this.viewport = null;
            this.map = null;
        }
    }

    public void setResolutions(double[] resolutions) {
        this.resolutions = resolutions;
    }

    public void zoomTo(final int level) {
        if (this.resolutions == null) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViewportModel model = MapViewer.this.map.getViewportModelInternal();
                double nextresolution = MapViewer.this.resolutions[level];
                double centerx = model.getCenter().x;
                double centery = model.getCenter().y;
                double pixelwidth = MapViewer.this.viewport.getWidth();
                double newunitwidth = nextresolution * pixelwidth;
                double xmin = centerx - newunitwidth / 2.0;
                double xmax = centerx + newunitwidth / 2.0;
                double newunitheight = nextresolution * (double)MapViewer.this.viewport.getHeight();
                double ymin = centery - newunitheight / 2.0;
                double ymax = centery + newunitheight / 2.0;
                ReferencedEnvelope re = new ReferencedEnvelope(xmin, xmax, ymin, ymax, model.getCRS());
                MapViewer.this.map.sendCommandSync((MapCommand)new SetViewportBBoxCommand(re));
            }
        });
    }
}

