/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.tool.selection.provider;

import net.refractions.udig.core.filter.AdaptingFilter;
import net.refractions.udig.core.filter.AdaptingFilterFactory;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import net.refractions.udig.project.ui.tool.selection.provider.AbstractMapEditorSelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.opengis.filter.Filter;

public class FilterSelectionProvider
extends AbstractMapEditorSelectionProvider
implements IMapEditorSelectionProvider {
    private ILayerListener layerListener = new ILayerListener(){

        public void refresh(LayerEvent event) {
            if (event.getSource() != FilterSelectionProvider.this.map.getEditManager().getSelectedLayer()) {
                event.getSource().removeListener((ILayerListener)this);
            }
            if (event.getType() == LayerEvent.EventType.FILTER) {
                AdaptingFilter filter = AdaptingFilterFactory.createAdaptingFilter((Filter)((Filter)event.getNewValue()), (Object)event.getSource());
                FilterSelectionProvider.this.selection = new StructuredSelection((Object)filter);
                FilterSelectionProvider.this.notifyListeners();
            }
        }
    };
    private IMap map;
    private IEditManagerListener editManagerListener = new IEditManagerListener(){

        public void changed(EditManagerEvent event) {
            if (event.getSource().getMap() != FilterSelectionProvider.this.map) {
                event.getSource().removeListener((IEditManagerListener)this);
                return;
            }
            if (event.getType() == 5) {
                ILayer selectedLayer;
                ILayer oldLayer = (ILayer)event.getOldValue();
                if (oldLayer != null) {
                    oldLayer.removeListener(FilterSelectionProvider.this.layerListener);
                }
                if ((selectedLayer = (ILayer)event.getNewValue()) != null) {
                    selectedLayer.addListener(FilterSelectionProvider.this.layerListener);
                    AdaptingFilter filter = AdaptingFilterFactory.createAdaptingFilter((Filter)selectedLayer.getFilter(), (Object)selectedLayer);
                    FilterSelectionProvider.this.selection = new StructuredSelection((Object)filter);
                }
                FilterSelectionProvider.this.notifyListeners();
            }
        }
    };

    @Override
    public void setActiveMap(IMap map, MapPart editor) {
        this.map = map;
        if (map == null || map.getMapLayers().size() == 0) {
            this.selection = new StructuredSelection();
            this.notifyListeners();
        } else {
            ILayer selectedLayer = map.getEditManager().getSelectedLayer();
            if (selectedLayer != null) {
                selectedLayer.addListener(this.layerListener);
                AdaptingFilter filter = AdaptingFilterFactory.createAdaptingFilter((Filter)selectedLayer.getFilter(), (Object)selectedLayer);
                this.selection = new StructuredSelection((Object)filter);
                this.notifyListeners();
            }
        }
        if (map != null && map.getEditManager() != null && !map.getEditManager().containsListener(this.editManagerListener)) {
            map.getEditManager().addListener(this.editManagerListener);
        }
    }
}

