/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.summary;

import java.util.Collection;
import net.refractions.udig.project.ui.summary.SummaryCellEditorValidator;
import net.refractions.udig.project.ui.summary.SummaryCellModifier;
import net.refractions.udig.project.ui.summary.SummaryData;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class SummaryControl {
    private static final String VALUE = "VALUE";
    private Collection<SummaryData> data;
    private TreeViewer viewer;

    public SummaryControl(Collection<SummaryData> data) {
        this.data = data;
    }

    public Control createControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 65540);
        Tree tree = this.viewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 200));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 200));
        TreeColumn nameColumn = new TreeColumn(tree, 16384);
        nameColumn.setWidth(200);
        TreeColumn infoColumn = new TreeColumn(tree, 16640);
        this.viewer.setContentProvider((IContentProvider)new SummaryDataProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SummaryLabelProvider());
        this.viewer.setInput(this.data);
        this.viewer.setColumnProperties(new String[]{"TITLE", VALUE});
        infoColumn.pack();
        this.setCellEditor(this.viewer);
        return tree;
    }

    private void setCellEditor(TreeViewer viewer) {
        TextCellEditor textCellEditor = new TextCellEditor((Composite)viewer.getTree());
        textCellEditor.setValidator((ICellEditorValidator)new SummaryCellEditorValidator(this.data, viewer.getTree()));
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = textCellEditor;
        viewer.setCellEditors(cellEditorArray);
        viewer.setCellModifier((ICellModifier)new SummaryCellModifier(this.data));
    }

    public void refresh(Object element) {
        this.viewer.refresh(element);
    }

    public void applyEdit() {
        this.viewer.getCellEditors()[1].deactivate();
    }

    public void cancelEdit() {
        this.viewer.cancelEditing();
    }

    private class SummaryDataProvider
    implements ITreeContentProvider {
        private SummaryDataProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == SummaryControl.this.data) {
                return SummaryControl.this.data.toArray();
            }
            if (parentElement instanceof SummaryData) {
                return ((SummaryData)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof SummaryData) {
                SummaryData parent = ((SummaryData)element).getParent();
                if (parent == null) {
                    return SummaryControl.this.data;
                }
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            SummaryData[] children;
            if (element == SummaryControl.this.data) {
                return true;
            }
            return element instanceof SummaryData && (children = ((SummaryData)element).getChildren()) != null && children.length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class SummaryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private SummaryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof SummaryData)) {
                return null;
            }
            SummaryData data = (SummaryData)element;
            if (columnIndex == 0) {
                return data.getTitle();
            }
            return data.getInfo();
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return null;
            }
            SummaryData data = (SummaryData)element;
            if (data.getModifier().canModify(element, SummaryControl.VALUE)) {
                return null;
            }
            return Display.getCurrent().getSystemColor(16);
        }
    }
}

