/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.preferences;

import java.awt.Color;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.Glyph;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;

public class PaletteSelectionFieldEditor
extends FieldEditor {
    TableViewer palettes;

    public PaletteSelectionFieldEditor(String name, String string, Composite parent) {
        super(name, string, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.palettes.getControl().getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.palettes = this.getTableControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 95;
        this.palettes.getControl().setLayoutData((Object)gd);
    }

    private TableViewer getTableControl(Composite parent) {
        TableViewer paletteTable = new TableViewer(new Table(parent, 68352));
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20, false));
        TableColumn firstColumn = new TableColumn(paletteTable.getTable(), 16384);
        firstColumn.setAlignment(16384);
        paletteTable.getTable().setLayout((Layout)tableLayout);
        paletteTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof BrewerPalette) {
                    BrewerPalette palette = (BrewerPalette)element;
                    return Glyph.palette((Color[])palette.getColors(palette.getMaxColors())).createImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof BrewerPalette) {
                    BrewerPalette palette = (BrewerPalette)element;
                    String text = null;
                    text = String.valueOf(palette.getName()) + ": " + palette.getDescription();
                    if (text == null) {
                        text = palette.getName();
                    }
                    return text;
                }
                return null;
            }
        });
        paletteTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ColorBrewer) {
                    ColorBrewer brewer = (ColorBrewer)inputElement;
                    return brewer.getPalettes();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        paletteTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof BrewerPalette && e2 instanceof BrewerPalette) {
                    BrewerPalette p1 = (BrewerPalette)e1;
                    BrewerPalette p2 = (BrewerPalette)e2;
                    return p1.getName().compareTo(p2.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        paletteTable.setInput((Object)PlatformGIS.getColorBrewer());
        return paletteTable;
    }

    protected void doLoad() {
        if (this.palettes != null) {
            this.select(this.getPreferenceStore().getString(this.getPreferenceName()));
        }
    }

    protected void doLoadDefault() {
        if (this.palettes != null) {
            this.select(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
        }
    }

    private void select(String paletteName) {
        ColorBrewer brewer = PlatformGIS.getColorBrewer();
        if (paletteName == null || !brewer.hasPalette(paletteName)) {
            return;
        }
        BrewerPalette palette = brewer.getPalette(paletteName);
        this.palettes.setSelection((ISelection)new StructuredSelection((Object)palette));
    }

    protected void doStore() {
        ISelection select = this.palettes.getSelection();
        if (select == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        BrewerPalette palette = (BrewerPalette)((StructuredSelection)select).getFirstElement();
        this.getPreferenceStore().setValue(this.getPreferenceName(), palette.getName());
    }

    public int getNumberOfControls() {
        return 2;
    }
}

