/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.operations.example;

import java.text.MessageFormat;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.FilterAttributeExtractor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class SelectedFeatureop
implements IOp {
    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Counting features", -1);
        monitor.worked(1);
        ILayer layer = (ILayer)target;
        FeatureSource source = (FeatureSource)layer.getResource(FeatureSource.class, (IProgressMonitor)new NullProgressMonitor());
        FilterAttributeExtractor extractor = new FilterAttributeExtractor((SimpleFeatureType)source.getSchema());
        layer.getFilter().accept((FilterVisitor)extractor, null);
        String[] atts = extractor.getAttributeNames();
        Query query = new Query(((SimpleFeatureType)source.getSchema()).getTypeName(), (Filter)Filter.INCLUDE, atts);
        FeatureCollection allCollection = source.getFeatures(query);
        FeatureIterator allFeatures = allCollection.features();
        try {
            int selectedCount = 0;
            int allCount = 0;
            long lastUpdate = System.currentTimeMillis();
            while (allFeatures.hasNext()) {
                SimpleFeature next = (SimpleFeature)allFeatures.next();
                ++allCount;
                if (layer.getFilter().evaluate((Object)next)) {
                    ++selectedCount;
                }
                if (System.currentTimeMillis() - lastUpdate <= 1000L) continue;
                monitor.setTaskName("Count: Processed " + allCount + " features");
                lastUpdate = System.currentTimeMillis();
            }
            final int finalAllCount = allCount;
            final int finalSelectedCount = selectedCount;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    String pattern = "There are {0} features in the current layer, of which {1} are selected";
                    String message = MessageFormat.format(pattern, finalAllCount, finalSelectedCount);
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)"Selected Features", (String)message);
                }
            });
        }
        finally {
            allFeatures.close();
            monitor.done();
        }
    }
}

