/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.operations.example;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.operations.example.LayerSummary;
import net.refractions.udig.project.ui.summary.SummaryData;
import net.refractions.udig.project.ui.summary.SummaryDialog;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.wms.WebMapServer;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MultiTargetOp
implements IOp {
    public void op(Display display, Object target, IProgressMonitor monitor) throws Exception {
        if (target instanceof IGeoResource) {
            IGeoResource resource = (IGeoResource)target;
            this.op(display, monitor, resource);
        } else if (target instanceof FeatureSource) {
            FeatureSource source = (FeatureSource)target;
            this.op(display, monitor, (FeatureSource<SimpleFeatureType, SimpleFeature>)source);
        }
    }

    private void op(final Display display, IProgressMonitor monitor, IGeoResource resource) throws IOException {
        IGeoResourceInfo info = resource.getInfo(monitor);
        ReferencedEnvelope bounds = info.getBounds();
        final ArrayList<SummaryData> data = new ArrayList<SummaryData>();
        String crs = info.getCRS() != null ? info.getCRS().getName().toString() : Messages.MultiTargetOp_unknown;
        crs = crs.replace('\n', ' ');
        try {
            data.add(new SummaryData(Messages.MultiTargetOp_name, info.getName()));
            data.add(new SummaryData(Messages.MultiTargetOp_title, info.getTitle()));
            data.add(new SummaryData(Messages.MultiTargetOp_bounds, LayerSummary.parseBounds((Envelope)bounds)));
            data.add(new SummaryData(Messages.MultiTargetOp_crs, crs));
            data.add(new SummaryData(Messages.MultiTargetOp_featuresource, resource.canResolve(FeatureSource.class)));
            data.add(new SummaryData(Messages.MultiTargetOp_featurestore, resource.canResolve(FeatureStore.class)));
            data.add(new SummaryData(Messages.MultiTargetOp_wms, resource.canResolve(WebMapServer.class)));
            boolean first = false;
            for (String word : info.getKeywords()) {
                if (first) {
                    data.add(new SummaryData(Messages.MultiTargetOp_keywords, word));
                    continue;
                }
                data.add(new SummaryData(null, word));
            }
        }
        catch (Exception e) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)Messages.MultiTargetOp_resource_summary, (String)Messages.MultiTargetOp_error);
                }
            });
            ProjectUIPlugin.log(null, e);
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SummaryDialog d = new SummaryDialog(display.getActiveShell(), Messages.MultiTargetOp_resource_summary, data);
                d.setBlockOnOpen(true);
                d.open();
            }
        });
    }

    private void op(final Display display, IProgressMonitor monitor, FeatureSource<SimpleFeatureType, SimpleFeature> source) throws IOException {
        int tmp = 0;
        tmp = source.getCount(Query.ALL);
        if (tmp == -1) {
            FeatureIterator iter = source.getFeatures().features();
            try {
                while (iter.hasNext()) {
                    try {
                        iter.next();
                    }
                    catch (Exception exception) {}
                    ++tmp;
                }
            }
            finally {
                iter.close();
            }
        }
        final int features = tmp;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)display.getActiveShell(), (String)"Number of features", (String)(String.valueOf(Messages.MultiTargetOp_number) + (features == -1 ? Messages.MultiTargetOp_expensive : String.valueOf(features))));
            }
        });
    }
}

