/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.operations;

import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.catalog.util.GeoToolsAdapters;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Not;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public class MakeHole
implements IOp {
    public void op(Display display, Object target, IProgressMonitor monitor) throws Exception {
        final ILayer layer = (ILayer)target;
        IMap map = layer.getMap();
        DefaultQuery query = new DefaultQuery(layer.getSchema().getTypeName(), layer.getFilter());
        FeatureSource featureSource = (FeatureSource)layer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        FeatureCollection features = featureSource.getFeatures((Query)query);
        final Geometry[] union = new Geometry[1];
        features.accepts(new FeatureVisitor(){

            public void visit(Feature feature) {
                SimpleFeature simple = (SimpleFeature)feature;
                Geometry geometry = (Geometry)simple.getDefaultGeometry();
                union[0] = union[0] == null ? geometry : union[0].union(geometry);
            }
        }, (ProgressListener)GeoToolsAdapters.progress((IProgressMonitor)monitor));
        final Geometry hole = union[0];
        AbstractCommand drillHoleCommand = new AbstractCommand(){

            public void run(IProgressMonitor monitor) throws Exception {
                for (Layer targetLayer : this.getMap().getLayersInternal()) {
                    SimpleFeatureType targetType;
                    if (targetLayer == layer || (targetType = targetLayer.getSchema()) == null) continue;
                    String targetGeomName = targetType.getGeometryDescriptor().getLocalName();
                    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
                    Not cut = ff.not((Filter)ff.within((Expression)ff.property(targetGeomName), (Expression)ff.literal((Object)hole)));
                    IStyleBlackboard styleBlackboard = layer.getStyleBlackboard();
                    styleBlackboard.put("net.refractions.udig.project.view", (Object)cut);
                }
            }

            public Command copy() {
                return this;
            }

            public String getName() {
                return "Create Hole Command";
            }
        };
        map.sendCommandSync((MapCommand)drillHoleCommand);
    }
}

