/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.wizard.url;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.ServiceFactoryImpl;
import net.refractions.udig.catalog.ui.AbstractUDIGImportPage;
import net.refractions.udig.catalog.ui.UDIGConnectionPage;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class URLWizardPage
extends AbstractUDIGImportPage
implements ModifyListener,
UDIGConnectionPage {
    static final String[] types = new String[0];
    protected Combo url;
    private static final String URL_WIZARD = "URL_WIZARD";
    private static final String URL_RECENT = "URL_RECENT";
    private IDialogSettings settings = ProjectUIPlugin.getDefault().getDialogSettings().getSection("URL_WIZARD");
    private static final int COMBO_HISTORY_LENGTH = 15;

    public URLWizardPage() {
        super(Messages.URLWizardPage_title);
        if (this.settings == null) {
            this.settings = ProjectUIPlugin.getDefault().getDialogSettings().addNewSection(URL_WIZARD);
        }
    }

    public String getId() {
        return null;
    }

    public boolean canProcess(Object object) {
        URL url = CatalogPlugin.locateURL((Object)object);
        return url != null;
    }

    public Map<String, Serializable> toParams(Object object) {
        return null;
    }

    public void createControl(Composite parent) {
        int columns;
        String[] recentURLs = this.settings.getArray(URL_RECENT);
        if (recentURLs == null) {
            recentURLs = new String[]{};
        }
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.URLWizardPage_label_url_text);
        urlLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        this.url = new Combo(composite, 2048);
        this.url.setItems(recentURLs);
        this.url.setVisibleItemCount(15);
        this.url.setLayoutData((Object)gridData);
        this.url.setText("http://");
        this.url.addModifyListener((ModifyListener)this);
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public boolean isPageComplete() {
        try {
            new URL(this.url.getText());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        IWizardPage[] pages = this.getWizard().getPages();
        return this.isPageComplete() && !pages[pages.length - 1].equals((Object)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        e.getClass();
        if (this.getWizard().canFinish()) {
            this.getWizard().performFinish();
        }
    }

    public List<IService> getResources(IProgressMonitor monitor) throws Exception {
        URL location = new URL(this.url.getText());
        ServiceFactoryImpl serviceFactory = new ServiceFactoryImpl();
        List services = serviceFactory.createService(location);
        this.saveWidgetValues();
        return services;
    }

    public void modifyText(ModifyEvent e) {
        try {
            new URL(this.url.getText());
            this.setErrorMessage(null);
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(Messages.URLWizardPage_error_invalidURL);
        }
        this.getWizard().getContainer().updateButtons();
    }

    private void saveWidgetValues() {
        if (this.settings != null) {
            String[] recentURLs = this.settings.getArray(URL_RECENT);
            if (recentURLs == null) {
                recentURLs = new String[]{};
            }
            recentURLs = this.addToHistory(recentURLs, this.url.getText());
            this.settings.put(URL_RECENT, recentURLs);
        }
    }

    private String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    private void addToHistory(List<String> history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 15) {
            history.remove(15);
        }
    }

    public Map<String, Serializable> getParams() {
        return null;
    }

    public List<URL> getURLs() {
        return null;
    }
}

