/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.ui.wizard.CatalogImportWizard;
import net.refractions.udig.catalog.ui.workflow.EndConnectionState;
import net.refractions.udig.catalog.ui.workflow.ResourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;

public class MapImportWizard
extends CatalogImportWizard {
    int layerPosition = -1;

    public MapImportWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
        this(workflow, map, -1);
    }

    public MapImportWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map, int layerPosition) {
        super(workflow, map);
        this.setWindowTitle("Add Data");
        this.layerPosition = layerPosition;
    }

    public void setLayerPosition(int layerPosition) {
        this.layerPosition = layerPosition;
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    protected boolean performFinish(IProgressMonitor monitor) {
        Map resourceMap;
        boolean superFinished;
        String name = Messages.MapImport_createMap;
        monitor.beginTask(name, -1);
        monitor.setTaskName(name);
        EndConnectionState catalogImportState = (EndConnectionState)this.getWorkflow().getState(EndConnectionState.class);
        if (catalogImportState != null && !(superFinished = super.performFinish(monitor))) {
            return superFinished;
        }
        ArrayList<IGeoResource> resourceList = new ArrayList<IGeoResource>();
        ResourceSelectionState state = (ResourceSelectionState)this.getWorkflow().getState(ResourceSelectionState.class);
        if (state != null && (resourceMap = state.getResources()) != null && !resourceMap.isEmpty()) {
            resourceList.addAll(resourceMap.keySet());
        }
        if (resourceList.isEmpty()) {
            return false;
        }
        Collections.reverse(resourceList);
        monitor.setTaskName(Messages.MapImport_addingLayersTask);
        ApplicationGIS.addLayersToMap(ApplicationGIS.getActiveMap(), resourceList, this.layerPosition, null, true);
        return true;
    }

    protected boolean isShowCatalogView() {
        return false;
    }
}

