/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.impl;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Rectangle;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.EditCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.command.factory.BasicCommandFactory;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.command.factory.NavigationCommandFactory;
import net.refractions.udig.project.command.factory.SelectionCommandFactory;
import net.refractions.udig.project.internal.impl.AbstractContextImpl;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.commands.DrawCommandFactory;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.tool.ToolContext;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class ToolContextImpl
extends AbstractContextImpl
implements ToolContext {
    private final DrawCommandFactory drawFactory = DrawCommandFactory.getInstance();
    private final EditCommandFactory editFactory = EditCommandFactory.getInstance();
    private final NavigationCommandFactory navigationFactory = NavigationCommandFactory.getInstance();
    private final SelectionCommandFactory selectionFactory = SelectionCommandFactory.getInstance();
    private final BasicCommandFactory basicCommandFactory = BasicCommandFactory.getInstance();

    public ToolContextImpl() {
    }

    public ToolContextImpl(ToolContextImpl impl) {
        super((AbstractContextImpl)impl);
    }

    @Override
    public DrawCommandFactory getDrawFactory() {
        return this.drawFactory;
    }

    @Override
    public EditCommandFactory getEditFactory() {
        return this.editFactory;
    }

    @Override
    public NavigationCommandFactory getNavigationFactory() {
        return this.navigationFactory;
    }

    @Override
    public SelectionCommandFactory getSelectionFactory() {
        return this.selectionFactory;
    }

    public void sendCommand(IDrawCommand command) {
        Rectangle validArea;
        command.setMap(this.getMap());
        ViewportPane viewportPane = (ViewportPane)this.getRenderManagerInternal().getMapDisplay();
        viewportPane.addDrawCommand(command);
        try {
            validArea = command.getValidArea();
        }
        catch (Exception exception) {
            validArea = null;
        }
        if (validArea != null) {
            viewportPane.repaint(validArea.x, validArea.y, validArea.width, validArea.height);
        } else {
            viewportPane.repaint();
        }
    }

    @Override
    public void sendASyncCommand(Command command) {
        if (command instanceof NavCommand) {
            this.getMapInternal().sendCommandASync((MapCommand)((NavCommand)command));
        } else if (command instanceof EditCommand) {
            this.getMapInternal().sendCommandASync((MapCommand)((EditCommand)command));
        } else if (command instanceof IDrawCommand) {
            this.sendCommand((IDrawCommand)command);
        } else if (command instanceof MapCommand) {
            this.getMapInternal().sendCommandASync((MapCommand)command);
        } else {
            this.getProjectInternal().sendASync(command);
        }
    }

    @Override
    public void sendSyncCommand(Command command) {
        if (command instanceof NavCommand) {
            this.getMapInternal().sendCommandSync((MapCommand)((NavCommand)command));
        } else if (command instanceof EditCommand) {
            this.getMapInternal().sendCommandSync((MapCommand)((EditCommand)command));
        } else if (command instanceof IDrawCommand) {
            this.sendCommand((IDrawCommand)command);
        } else if (command instanceof MapCommand) {
            this.getMapInternal().sendCommandSync((MapCommand)command);
        } else {
            this.getProjectInternal().sendSync(command);
        }
    }

    @Override
    public ViewportPane getViewportPane() {
        return (ViewportPane)this.getMapDisplay();
    }

    @Override
    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Override
    public Display getDisplay() {
        return Display.getDefault();
    }

    @Override
    public void log(Plugin currentPlugin, String message, int severity, Throwable exception) {
        String ID1 = currentPlugin.getBundle().getSymbolicName();
        currentPlugin.getLog().log((IStatus)new Status(severity, ID1, 0, message, exception));
    }

    public RenderManager getRenderManagerInternal() {
        return this.getMapInternal().getRenderManagerInternal();
    }

    @Override
    public IStatusLineManager getStatusBar() {
        IActionBars2 bars = this.getActionBars();
        if (bars == null) {
            return null;
        }
        return bars.getStatusLineManager();
    }

    @Override
    public IActionBars2 getActionBars() {
        IViewReference[] views;
        IEditorReference[] editors;
        IWorkbenchWindow window = this.getWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor instanceof MapPart) {
                MapPart mapPart = (MapPart)editor;
                if (this.getMap() == mapPart.getMap()) {
                    return (IActionBars2)editor.getEditorSite().getActionBars();
                }
            }
            ++n2;
        }
        IViewReference[] iViewReferenceArray = views = page.getViewReferences();
        int n3 = views.length;
        n = 0;
        while (n < n3) {
            IViewReference ref = iViewReferenceArray[n];
            IViewPart view = ref.getView(false);
            if (view instanceof MapPart) {
                MapPart mapPart = (MapPart)view;
                if (this.getMap() == mapPart.getMap()) {
                    return new IActionBars2Adapter(view);
                }
            }
            ++n;
        }
        return null;
    }

    private IWorkbenchWindow getWindow() {
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench == null) {
            return null;
        }
        IWorkbenchWindow window = bench.getActiveWorkbenchWindow();
        if (window == null && bench.getWorkbenchWindowCount() > 0) {
            window = bench.getWorkbenchWindows()[0];
        }
        return window;
    }

    @Override
    public void updateUI(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
            return;
        }
        IWorkbench bench = PlatformUI.getWorkbench();
        Display display = null;
        if (bench != null) {
            display = bench.getDisplay();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(runnable);
    }

    @Override
    public BasicCommandFactory getBasicCommandFactory() {
        return this.basicCommandFactory;
    }

    @Override
    public ToolContextImpl copy() {
        return new ToolContextImpl(this);
    }

    @Override
    public double calculateZoomLevel(double previousZoom, double zoom, Coordinate fixedPoint, boolean alwayUsePreferredZoomLevels, boolean alwaysChangeZoom) {
        ScaleUtils.CalculateZoomLevelParameter params = new ScaleUtils.CalculateZoomLevelParameter(this.getViewportModelInternal(), (IMapDisplay)this.getViewportPane(), previousZoom, zoom, fixedPoint, alwayUsePreferredZoomLevels, alwaysChangeZoom, ScaleUtils.zoomClosenessPreference());
        return ScaleUtils.calculateZoomLevel((ScaleUtils.CalculateZoomLevelParameter)params);
    }

    private final class IActionBars2Adapter
    implements IActionBars2 {
        IActionBars bars;

        private IActionBars2Adapter(IViewPart view) {
            this.bars = view.getViewSite().getActionBars();
        }

        public void clearGlobalActionHandlers() {
            this.bars.clearGlobalActionHandlers();
        }

        public IAction getGlobalActionHandler(String actionId) {
            return this.bars.getGlobalActionHandler(actionId);
        }

        public IMenuManager getMenuManager() {
            return this.bars.getMenuManager();
        }

        public IServiceLocator getServiceLocator() {
            return this.bars.getServiceLocator();
        }

        public IStatusLineManager getStatusLineManager() {
            return this.bars.getStatusLineManager();
        }

        public IToolBarManager getToolBarManager() {
            return this.bars.getToolBarManager();
        }

        public void setGlobalActionHandler(String actionId, IAction handler) {
            this.bars.setGlobalActionHandler(actionId, handler);
        }

        public void updateActionBars() {
            this.bars.updateActionBars();
        }

        public ICoolBarManager getCoolBarManager() {
            return null;
        }
    }
}

