/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.MapEditorSelectionProvider;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.display.AbstractToolbarContributionItem;
import net.refractions.udig.project.ui.internal.tool.display.ModalItem;
import net.refractions.udig.project.ui.internal.tool.display.ToolCategory;
import net.refractions.udig.project.ui.internal.tool.display.ToolCommandHandler;
import net.refractions.udig.project.ui.internal.tool.display.ToolManager;
import net.refractions.udig.project.ui.internal.tool.display.ToolProxy;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import net.refractions.udig.project.ui.tool.IToolManager;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ModalToolCategory
extends ToolCategory {
    private CurrentModalToolContribution contribution;
    private PaletteContainer container;
    private IHandler handler;
    private IMapEditorSelectionProvider selectionProviderInstance;

    public ModalToolCategory(IConfigurationElement element, IToolManager manager) {
        super(element, manager);
    }

    public ModalToolCategory(IToolManager manager) {
        super(manager);
    }

    @Override
    protected IHandler getHandler() {
        if (this.handler == null) {
            this.handler = new ToolCommandHandler(this);
        }
        return this.handler;
    }

    public AbstractToolbarContributionItem getContribution() {
        return this.contribution;
    }

    public void hook(PaletteContainer container) {
        this.container = container;
    }

    public void container(PaletteContainer container) {
        this.container = container;
    }

    public void contribute(IToolBarManager manager) {
        CurrentModalToolContribution old = this.contribution;
        this.contribution = new CurrentModalToolContribution();
        manager.add((IContributionItem)this.contribution);
        for (ModalItem item : this) {
            ToolProxy tool = (ToolProxy)item;
            if (tool.getType() != 1) continue;
            if (old != null) {
                tool.removeContribution(old);
            }
            tool.addContribution(this.contribution);
        }
    }

    public IMapEditorSelectionProvider getSelectionProvider() {
        if (this.selectionProviderInstance == null) {
            if (this.element.getAttribute("selectionProvider") != null) {
                try {
                    this.selectionProviderInstance = (IMapEditorSelectionProvider)this.element.createExecutableExtension("selectionProvider");
                }
                catch (CoreException e) {
                    ProjectUIPlugin.log("Error instantiating selection provider for " + this.element.getNamespace() + "/" + this.element.getName(), e);
                    this.selectionProviderInstance = new MapEditorSelectionProvider();
                }
            } else {
                this.selectionProviderInstance = new MapEditorSelectionProvider();
            }
        }
        return this.selectionProviderInstance;
    }

    public PaletteContainer getContainer() {
        return this.container;
    }

    protected class CurrentModalToolContribution
    extends AbstractToolbarContributionItem {
        protected CurrentModalToolContribution() {
        }

        @Override
        protected ToolItem createToolItem(ToolBar parent, int index) {
            ToolItem item = new ToolItem(parent, 4, index);
            return item;
        }

        @Override
        protected void runCurrentTool() {
            super.runCurrentTool();
            IMapEditorSelectionProvider provider = ((ToolProxy)this.currentTool).getSelectionProvider();
            MapEditorPart editor = ApplicationGISInternal.getActiveEditor();
            if (editor != null) {
                editor.setSelectionProvider(provider);
            }
        }

        @Override
        protected List<ModalItem> getTools() {
            ArrayList<ModalItem> onToolbar = new ArrayList<ModalItem>();
            ModalItem enabled = null;
            for (ModalItem item : ModalToolCategory.this.items) {
                if (((ToolProxy)item).isOnToolbar()) {
                    onToolbar.add(item);
                }
                if (!item.isEnabled() || enabled != null || !((ToolProxy)item).isOnToolbar()) continue;
                enabled = item;
            }
            if (enabled != null) {
                onToolbar.remove(enabled);
                onToolbar.add(0, enabled);
            }
            return onToolbar;
        }

        @Override
        protected boolean isDefaultItem() {
            return this.getTools().contains(((ToolManager)ModalToolCategory.this.manager).defaultModalToolProxy);
        }

        @Override
        protected boolean isActiveItem() {
            return this.getTools().contains(((ToolManager)ModalToolCategory.this.manager).getActiveToolProxy());
        }
    }
}

