/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.refractions.udig.internal.ui.operations.OperationCategory;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapEditorWithPalette;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.MapToolEntry;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.display.CurrentContributionItem;
import net.refractions.udig.project.ui.internal.tool.display.ToolManager;
import net.refractions.udig.project.ui.viewers.MapEditDomain;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.Glyph;
import net.refractions.udig.ui.operations.ILazyOpListener;
import net.refractions.udig.ui.operations.OpFilter;
import org.eclipse.core.commands.IHandler;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public abstract class ModalItem
implements ILazyOpListener {
    private static ImageRegistry IMAGES = ProjectUIPlugin.getDefault().getImageRegistry();
    private List<CurrentContributionItem> contributions = new ArrayList<CurrentContributionItem>();
    private CopyOnWriteArrayList<MapToolEntry> mapToolEntries = new CopyOnWriteArrayList();
    protected String[] commandIds;
    protected String handlerType;
    protected ImageDescriptor imageDescriptor;
    protected String name;
    protected String toolTipText;
    protected String id;
    protected OpFilter enablement;
    protected List<OperationCategory> operationCategories;
    protected boolean isEnabled = true;
    private Lock enabledLock = new ReentrantLock();
    private String preferencePageId;
    private ImageDescriptor largeImageDescriptor;
    private List<ContributionItem> optionsContribution = new ArrayList<ContributionItem>();

    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    public ImageDescriptor getLargeImageDescriptor() {
        return this.largeImageDescriptor;
    }

    public void setChecked(boolean checked) {
        MapEditorWithPalette editor2;
        MapEditDomain editDomain;
        PaletteViewer paletteViewer;
        ArrayList<CurrentContributionItem> toRemove = new ArrayList<CurrentContributionItem>();
        for (CurrentContributionItem item : this.contributions) {
            if (item.isDisposed()) {
                toRemove.add(item);
                continue;
            }
            item.setSelection(checked, this);
        }
        this.contributions.removeAll(toRemove);
        ToolManager tools = (ToolManager)ApplicationGIS.getToolManager();
        MapPart currentEditor = tools.currentEditor;
        if (currentEditor != null && currentEditor instanceof MapEditorWithPalette && (paletteViewer = (editDomain = (editor2 = (MapEditorWithPalette)currentEditor).getEditDomain()).getPaletteViewer()) != null) {
            for (MapToolEntry entry : this.mapToolEntries) {
                if (paletteViewer.getEditPartRegistry().get((Object)entry) == null) continue;
                paletteViewer.setActiveTool((ToolEntry)entry);
                EditPart part = (EditPart)paletteViewer.getEditPartRegistry().get((Object)entry);
                paletteViewer.reveal(part);
                break;
            }
        }
    }

    public void run() {
        if (this.isModeless()) {
            this.runModeless();
            if (this.isEnabled()) {
                return;
            }
        } else {
            this.runModal();
        }
        this.setActive(true);
        ModalItem activeModalItem = this.getActiveItem();
        if (activeModalItem != this) {
            if (activeModalItem != null) {
                activeModalItem.setActive(false);
            }
            this.setActiveItem(this);
        }
    }

    protected abstract ModalItem getDefaultItem();

    protected abstract ModalItem getActiveItem();

    protected abstract void setActiveItem(ModalItem var1);

    protected boolean isModeless() {
        return false;
    }

    protected abstract void runModeless();

    protected abstract void runModal();

    public abstract void dispose();

    public abstract boolean isDisposed();

    protected abstract void setActive(boolean var1);

    public List<CurrentContributionItem> getContributions() {
        return Collections.unmodifiableList(this.contributions);
    }

    public boolean addContribution(CurrentContributionItem contribution) {
        contribution.setEnabled(this.isEnabled());
        return this.contributions.add(contribution);
    }

    public CurrentContributionItem removeContribution(int index) {
        return this.contributions.remove(index);
    }

    public boolean removeContribution(CurrentContributionItem contribution) {
        return this.contributions.remove((Object)contribution);
    }

    public void clearContributions() {
        this.contributions.clear();
    }

    public CopyOnWriteArrayList<MapToolEntry> getMapToolEntries() {
        return this.mapToolEntries;
    }

    public abstract IHandler getHandler(String var1);

    public String[] getCommandIds() {
        String[] c = new String[this.commandIds.length];
        System.arraycopy(this.commandIds, 0, c, 0, c.length);
        return c;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    public void setImageDescriptor(ImageDescriptor imageDescriptor) {
        this.imageDescriptor = imageDescriptor;
        IMAGES.remove(this.getId());
    }

    public void setLargeImageDescriptor(ImageDescriptor imageDescriptor) {
        this.largeImageDescriptor = imageDescriptor;
        IMAGES.remove(String.valueOf(this.getId()) + "Large");
    }

    public Image getImage() {
        if (IMAGES.get(this.getId()) == null || IMAGES.get(this.getId()).isDisposed()) {
            IMAGES.remove(this.getId());
            IMAGES.put(this.getId(), this.getImageDescriptor());
        }
        return IMAGES.get(this.getId());
    }

    public Image getActiveImage() {
        if (this.getImageDescriptor() == null) {
            return null;
        }
        if (IMAGES.get(String.valueOf(this.getId()) + "pushed") == null || IMAGES.get(String.valueOf(this.getId()) + "pushed").isDisposed()) {
            IMAGES.put(String.valueOf(this.getId()) + "pushed", Glyph.push((ImageDescriptor)this.getImageDescriptor()));
        }
        return IMAGES.get(String.valueOf(this.getId()) + "pushed");
    }

    public OpFilter getEnablesFor() {
        if (this.enablement == null) {
            return OpFilter.TRUE;
        }
        return this.enablement;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(final boolean isEnabled) {
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ModalItem.this.internalSetEnabled(isEnabled);
            }
        });
    }

    protected void internalSetEnabled(boolean isEnabled2) {
        this.enabledLock.lock();
        try {
            this.isEnabled = isEnabled2;
            for (CurrentContributionItem contrib : this.getContributions()) {
                contrib.setEnabled(isEnabled2);
            }
            for (MapToolEntry entry : this.mapToolEntries) {
                entry.setVisible(isEnabled2);
            }
        }
        finally {
            this.enabledLock.unlock();
        }
    }

    public List<OperationCategory> getOperationCategories() {
        if (this.operationCategories == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.operationCategories);
    }

    public void setPreferencePageId(String id) {
        this.preferencePageId = id;
    }

    public String getPreferencePageId() {
        return this.preferencePageId;
    }

    public void addOptionsContribution(ContributionItem optionsPage) {
        this.optionsContribution.add(optionsPage);
    }

    public List<ContributionItem> getOptionsContribution() {
        return this.optionsContribution;
    }
}

