/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.objectproperty.ObjectPropertyCatalogListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.ui.operations.AbstractPropertyValue;
import net.refractions.udig.ui.operations.PropertyValue;
import org.geotools.data.FeatureStore;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeometryProperty
extends AbstractPropertyValue<ILayer>
implements PropertyValue<ILayer> {
    Set<String> ids = new CopyOnWriteArraySet<String>();
    private volatile AtomicBoolean isEvaluating = new AtomicBoolean(false);

    public synchronized boolean isTrue(ILayer object, String value) {
        this.isEvaluating.set(true);
        if (object.getMap() != null && object.getMap().getEditManager().isEditLayerLocked()) {
            object = object.getMap().getEditManager().getEditLayer();
        }
        try {
            SimpleFeatureType schema;
            IGeoResource resource;
            if (this.ids.add(object.getID().toString()) && (resource = object.findGeoResource(FeatureStore.class)) != null) {
                CatalogPlugin.getDefault().getLocalCatalog().addCatalogListener((IResolveChangeListener)new ObjectPropertyCatalogListener((Object)object, resource, this.isEvaluating, (AbstractPropertyValue)this));
            }
            if ((schema = object.getSchema()) == null || schema.getGeometryDescriptor() == null) {
                return false;
            }
            Class<? extends Object> declared = this.parseValue(value);
            Class type = schema.getGeometryDescriptor().getType().getBinding();
            boolean bl = type.isAssignableFrom(declared);
            return bl;
        }
        finally {
            this.isEvaluating.set(false);
        }
    }

    private Class<? extends Object> parseValue(String value) throws ClassNotFoundException {
        Class result = null;
        if (value.equalsIgnoreCase("geometry")) {
            result = Geometry.class;
        } else if (value.equalsIgnoreCase("polygon")) {
            result = Polygon.class;
        } else if (value.equalsIgnoreCase("line") || value.equalsIgnoreCase("linestring")) {
            result = LineString.class;
        } else if (value.equalsIgnoreCase("point")) {
            result = Point.class;
        } else if (value.equalsIgnoreCase("multipoint")) {
            result = MultiPoint.class;
        } else if (value.equalsIgnoreCase("multipolygon")) {
            result = MultiPolygon.class;
        } else if (value.equalsIgnoreCase("linearring")) {
            result = LinearRing.class;
        } else if (value.equalsIgnoreCase("multilinestring") || value.equalsIgnoreCase("multiline")) {
            result = MultiLineString.class;
        } else if (value.equalsIgnoreCase("geometrycollection")) {
            result = GeometryCollection.class;
        }
        if (result == null) {
            result = Class.forName(value);
        }
        return result;
    }

    public boolean canCacheResult() {
        return true;
    }

    public boolean isBlocking() {
        return true;
    }
}

