/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.tool.display;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CursorProxy {
    private volatile Cursor cursor;
    private String imagePath;
    private String hotspotX;
    private String hotspotY;
    private String cursorID;
    private String pluginID;

    public CursorProxy(IConfigurationElement configuration) {
        if (configuration != null) {
            this.imagePath = configuration.getAttribute("image");
            this.hotspotX = configuration.getAttribute("hotspotX");
            this.hotspotY = configuration.getAttribute("hotspotY");
            this.cursorID = configuration.getAttribute("id");
            this.pluginID = configuration.getNamespace();
        } else {
            this.cursorID = "default";
        }
    }

    public String getID() {
        return this.cursorID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor getCursor() {
        if (this.cursor == null) {
            CursorProxy cursorProxy = this;
            synchronized (cursorProxy) {
                if (this.cursor == null) {
                    if (this.imagePath == null) {
                        this.cursor = CursorProxy.getSystemCursor(this.cursorID);
                    } else {
                        int y;
                        int x;
                        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)this.pluginID, (String)this.imagePath);
                        try {
                            x = Integer.parseInt(this.hotspotX);
                        }
                        catch (Exception exception) {
                            x = 0;
                        }
                        try {
                            y = Integer.parseInt(this.hotspotY);
                        }
                        catch (Exception exception) {
                            y = 0;
                        }
                        this.cursor = imageDescriptor == null || imageDescriptor.getImageData() == null ? CursorProxy.getSystemCursor(this.cursorID) : new Cursor((Device)Display.getDefault(), imageDescriptor.getImageData(), x, y);
                    }
                }
            }
        }
        return this.cursor;
    }

    static Cursor getSystemCursor(String systemCursorID) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (systemCursorID == null) {
            return display.getSystemCursor(0);
        }
        if (systemCursorID.equals("crosshair")) {
            return display.getSystemCursor(2);
        }
        if (systemCursorID.equals("e_resize")) {
            return display.getSystemCursor(12);
        }
        if (systemCursorID.equals("hand")) {
            return display.getSystemCursor(21);
        }
        if (systemCursorID.equals("move")) {
            return display.getSystemCursor(5);
        }
        if (systemCursorID.equals("n_resize")) {
            return display.getSystemCursor(10);
        }
        if (systemCursorID.equals("ne_resize")) {
            return display.getSystemCursor(14);
        }
        if (systemCursorID.equals("nw_resize")) {
            return display.getSystemCursor(17);
        }
        if (systemCursorID.equals("s_resize")) {
            return display.getSystemCursor(11);
        }
        if (systemCursorID.equals("se_resize")) {
            return display.getSystemCursor(15);
        }
        if (systemCursorID.equals("sw_resize")) {
            return display.getSystemCursor(16);
        }
        if (systemCursorID.equals("text")) {
            return display.getSystemCursor(19);
        }
        if (systemCursorID.equals("w_resize")) {
            return display.getSystemCursor(16);
        }
        if (systemCursorID.equals("wait")) {
            return display.getSystemCursor(1);
        }
        if (systemCursorID.equals("no")) {
            return display.getSystemCursor(20);
        }
        return display.getSystemCursor(0);
    }

    public void dispose() {
        if (this.cursor != null) {
            this.cursor.dispose();
        }
        this.cursor = null;
    }
}

