/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.render.displayAdapter.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.displayAdapter.IMapDisplayListener;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.EventHandler;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.EventJob;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.ViewportPainter;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseMotionListener;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelListener;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.render.glass.GlassPane;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.AWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ViewportPaneJava
extends Panel
implements ViewportPane {
    ViewportPainter painter = new ViewportPainter(this);
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_DPI = 72;
    ViewportPane pane = this;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private VolatileImage vImage;
    VolatileImage buffer;
    private Composite composite = null;
    EventJob eventJob = new EventJob();
    private RenderManager renderManager;
    private EventHandler handler;
    private MapPart editor;
    private GlassPane glass;

    @Override
    public BufferedImage image(int w, int h) {
        return (BufferedImage)this.createImage(w, h);
    }

    public ViewportPaneJava(Composite comp, MapPart editor) {
        this.editor = editor;
        this.handler = new EventHandler(this, this.eventJob);
        comp.addListener(8, (Listener)this.handler);
        comp.addListener(3, (Listener)this.handler);
        comp.addListener(6, (Listener)this.handler);
        comp.addListener(7, (Listener)this.handler);
        comp.addListener(32, (Listener)this.handler);
        comp.addListener(5, (Listener)this.handler);
        comp.addListener(4, (Listener)this.handler);
        comp.addListener(37, (Listener)this.handler);
        comp.addListener(11, (Listener)this.handler);
        comp.addListener(1, (Listener)this.handler);
        Composite child = new Composite(comp, 0x1040000);
        child.setEnabled(false);
        SWT_AWT.new_Frame((Composite)child).add(this);
        this.composite = child;
        this.setBackgroundColor();
    }

    private void setBackgroundColor() {
        this.composite.setBackground(Display.getDefault().getSystemColor(1));
        this.setBackground(Color.WHITE);
    }

    @Override
    public void setRenderManager(RenderManager manager) {
        this.renderManager = manager;
    }

    @Override
    public void paint(Graphics g) {
        this.initializeViewportModel();
        if (this.vImage == null) {
            this.clearDisplay(g);
            return;
        }
        this.initializeBuffer();
        do {
            this.drawOnOffScreenBuffer();
            this.drawOnScreen(g);
        } while (this.buffer.contentsLost());
    }

    private void drawOnScreen(Graphics g) {
        int minWidth = Math.min(this.buffer.getWidth(), g.getClipBounds().width);
        int minHeight = Math.min(this.buffer.getHeight(), g.getClipBounds().height);
        g.drawImage(this.buffer, 0, 0, minWidth, minHeight, 0, 0, minWidth, minHeight, this);
    }

    private void drawOnOffScreenBuffer() {
        Graphics2D graphics = this.buffer.createGraphics();
        AWTGraphics vg = new AWTGraphics(graphics);
        do {
            int minWidth = Math.min(this.buffer.getWidth(), this.getWidth());
            int minHeight = Math.min(this.buffer.getHeight(), this.getHeight());
            this.validateVolitileImage();
            this.painter.paint((ViewportGraphics)vg, this.vImage, minWidth, minHeight);
        } while (this.vImage.contentsLost());
    }

    private void validateVolitileImage() {
        int returnCode = this.vImage.validate(this.getGraphicsConfiguration());
        if (returnCode == 1) {
            this.copyImageToVolitileImage(false);
        } else if (returnCode == 2) {
            this.vImage = this.createVolatileImage(this.getWidth(), this.getHeight());
            this.copyImageToVolitileImage(false);
        }
    }

    private void initializeBuffer() {
        if (this.buffer == null || this.buffer.getWidth() < this.getWidth() || this.buffer.getHeight() < this.getHeight()) {
            this.buffer = this.createVolatileImage(this.getWidth(), this.getHeight());
        }
    }

    private void clearDisplay(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void initializeViewportModel() {
        if (this.renderManager != null && !this.renderManager.getViewportModelInternal().isInitialized()) {
            Event event = new Event();
            event.display = Display.getDefault();
            this.handler.controlResized(event);
        }
    }

    void copyImageToVolitileImage(boolean clearImage) {
        if (this.vImage == null) {
            return;
        }
        do {
            if (this.vImage.validate(this.getGraphicsConfiguration()) == 2) {
                this.vImage = this.createVolatileImage(this.getWidth(), this.getHeight());
            }
            Graphics2D graphics = this.vImage.createGraphics();
            if (clearImage) {
                graphics.clearRect(0, 0, this.vImage.getWidth(), this.vImage.getHeight());
            }
            graphics.drawRenderedImage(this.getImage(), IDENTITY);
            graphics.dispose();
        } while (this.vImage.contentsLost());
    }

    private void initMap() {
        if (this.getImage() == null) {
            return;
        }
        if (this.vImage == null || this.vImage.getWidth() < this.getWidth() || this.vImage.getHeight() < this.getHeight()) {
            this.vImage = this.createVolatileImage(this.getWidth(), this.getHeight());
        }
        this.copyImageToVolitileImage(true);
    }

    RenderedImage getImage() {
        Renderer renderer;
        block4: {
            if (!Platform.isRunning()) {
                return null;
            }
            try {
                RenderExecutor renderExecutor = this.renderManager.getRenderExecutor();
                renderer = renderExecutor.getRenderer();
                if (renderer.getState() != 8) break block4;
                return null;
            }
            catch (Throwable e) {
                ProjectUIPlugin.log(null, e);
                return null;
            }
        }
        IRenderContext context = renderer.getContext();
        return context.getImage();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void update() {
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }

    @Override
    public void addDrawCommand(IDrawCommand command) {
        this.painter.addDrawCommand(command);
    }

    public Dimension getDisplaySize() {
        return this.getSize();
    }

    @Override
    public void removeMouseListener(MapMouseListener l) {
        this.eventJob.removeMouseListener(l);
    }

    @Override
    public void removeMouseMotionListener(MapMouseMotionListener l) {
        this.eventJob.removeMouseMotionListener(l);
    }

    @Override
    public void removeMouseWheelListener(MapMouseWheelListener l) {
        this.eventJob.removeMouseWheelListener(l);
    }

    @Override
    public void addMouseListener(MapMouseListener l) {
        this.eventJob.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(MapMouseMotionListener l) {
        this.eventJob.addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(MapMouseWheelListener l) {
        this.eventJob.addMouseWheelListener(l);
    }

    @Override
    public void renderStarting() {
        this.painter.renderStart();
        this.repaint();
    }

    @Override
    public void renderDone() {
        this.renderUpdate();
        this.painter.renderDone();
    }

    @Override
    public void renderUpdate() {
        this.initMap();
        if (this.getImage() != null) {
            this.painter.renderUpdate();
            this.repaint();
        }
    }

    @Override
    public void addPaneListener(IMapDisplayListener listener) {
        this.eventJob.addMapEditorListener(listener);
    }

    @Override
    public void removePaneListener(IMapDisplayListener listener) {
        this.eventJob.removeMapEditorListener(listener);
    }

    @Override
    public void setCursor(final Cursor cursor) {
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ViewportPaneJava.this.composite.getParent().setCursor(cursor);
            }
        }, (boolean)true);
    }

    @Override
    public MapPart getMapEditor() {
        return this.editor;
    }

    public int getDPI() {
        return 72;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void enableDrawCommands(boolean enable) {
        this.painter.switchOnOff(enable);
    }

    @Override
    public boolean isDisposed() {
        return this.composite.isDisposed();
    }

    @Override
    public GlassPane getGlass() {
        return this.glass;
    }

    @Override
    public void setGlass(GlassPane glass) {
        this.glass = glass;
    }
}

