/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.render.displayAdapter.impl;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.Tile;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import net.refractions.udig.project.ui.commands.IMapTransformCommand;
import net.refractions.udig.project.ui.commands.IPreMapDrawCommand;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.commands.draw.DrawEditFeatureCommand;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.render.glass.GlassPane;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.GC;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ViewportPainter {
    private CommandList commands = new CommandList();
    private ViewportPane pane;
    private int renderState = 0;
    private static final int RENDERING = 1;
    private static final int STARTING = 2;
    private static final int DONE = 4;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final boolean TESTING = ProjectUIPlugin.getDefault().isDebugging();
    private DrawEditFeatureCommand editfeatureCommand;
    private boolean enable = true;

    public ViewportPainter(ViewportPane pane) {
        this.pane = pane;
    }

    public void paint(ViewportGraphics g, Image image, int minWidth, int minHeight) {
        this.processCommands(g, true);
        this.clearPane(g, minWidth, minHeight);
        g.drawImage(image, 0, 0, minWidth, minHeight, 0, 0, minWidth, minHeight);
        this.drawGlassPane(g);
        this.processCommands(g, false);
        this.runEditFeatureCommand(g);
    }

    public void switchOnOff(boolean enable) {
        this.enable = enable;
    }

    private void clearPane(ViewportGraphics g, int minWidth, int minHeight) {
        if (!g.getTransform().isIdentity()) {
            AffineTransform t = g.getTransform();
            g.setTransform(IDENTITY);
            g.clearRect(0, 0, this.pane.getWidth(), this.pane.getHeight());
            g.setTransform(t);
        } else {
            if (minWidth < this.pane.getWidth()) {
                g.clearRect(minWidth, 0, this.pane.getWidth() - minWidth, this.pane.getHeight());
            }
            if (minHeight < this.pane.getHeight()) {
                g.clearRect(0, minHeight, this.pane.getWidth(), this.pane.getHeight() - minHeight);
            }
        }
    }

    public void paint(ViewportGraphics g, org.eclipse.swt.graphics.Image image, int minWidth, int minHeight) {
        this.processCommands(g, true);
        this.clearPane(g, minWidth, minHeight);
        if (image != null) {
            g.drawImage(image, 0, 0, minWidth, minHeight, 0, 0, minWidth, minHeight);
        }
        this.drawGlassPane(g);
        this.processCommands(g, false);
        this.runEditFeatureCommand(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(ViewportGraphics g, Map<ReferencedEnvelope, Tile> tiles, int minWidth, int minHeight) {
        this.processCommands(g, true);
        this.clearPane(g, minWidth, minHeight);
        if (tiles != null) {
            GC gc = (GC)g.getGraphics(GC.class);
            if (gc != null) {
                Set<ReferencedEnvelope> keySet = tiles.keySet();
                for (ReferencedEnvelope env : keySet) {
                    Tile tile = tiles.get(env);
                    ViewportModel viewportModelInternal = tile.getRenderExecutor().getRenderer().getContext().getViewportModelInternal();
                    Point a = viewportModelInternal.worldToPixel(new Coordinate(env.getMinX(), env.getMinY()));
                    Point b = viewportModelInternal.worldToPixel(new Coordinate(env.getMaxX(), env.getMaxY()));
                    int width = b.x - a.x;
                    int height = a.y - b.y;
                    Tile tile2 = tile;
                    synchronized (tile2) {
                        try {
                            org.eclipse.swt.graphics.Image im = tile.getSWTImage();
                            gc.drawImage(im, 0, 0, im.getBounds().width, im.getBounds().height, a.x, b.y, width, height);
                        }
                        catch (Exception exception) {}
                    }
                    if (!TESTING) continue;
                    g.setColor(Color.BLUE);
                    g.drawLine(a.x, a.y, a.x, b.y);
                    g.drawLine(a.x, b.y, b.x, b.y);
                    g.drawLine(b.x, b.y, b.x, a.y);
                    g.drawLine(b.x, a.y, a.x, a.y);
                }
            } else {
                Set<ReferencedEnvelope> keySet = tiles.keySet();
                for (ReferencedEnvelope env : keySet) {
                    Tile tile = tiles.get(env);
                    ViewportModel viewportModelInternal = tile.getRenderExecutor().getRenderer().getContext().getViewportModelInternal();
                    Point a = viewportModelInternal.worldToPixel(new Coordinate(env.getMinX(), env.getMinY()));
                    Point b = viewportModelInternal.worldToPixel(new Coordinate(env.getMaxX(), env.getMaxY()));
                    g.drawImage((RenderedImage)tile.getBufferedImage(), a.x, b.y);
                    g.setColor(Color.BLUE);
                    g.drawLine(a.x, a.y, a.x, b.y);
                    g.drawLine(a.x, b.y, b.x, b.y);
                    g.drawLine(b.x, b.y, b.x, a.y);
                    g.drawLine(b.x, a.y, a.x, a.y);
                }
            }
        }
        this.drawGlassPane(g);
        this.processCommands(g, false);
        this.runEditFeatureCommand(g);
    }

    private void runEditFeatureCommand(ViewportGraphics g) {
        if (this.editfeatureCommand == null && this.pane.getMapEditor().getMap().getViewportModelInternal() != null) {
            this.editfeatureCommand = new DrawEditFeatureCommand((IViewportModel)this.pane.getMapEditor().getMap().getViewportModelInternal());
        }
        if (this.editfeatureCommand != null) {
            this.editfeatureCommand.setGraphics(g, this.pane);
        }
    }

    private void processCommands(ViewportGraphics g, boolean pre) {
        try {
            IDrawCommand[] varray = null;
            varray = pre ? this.commands.getPreCommands() : this.commands.getPostCommands();
            int i = 0;
            while (i < varray.length) {
                block10: {
                    IDrawCommand command = varray[i];
                    if (command.isValid()) {
                        command.setGraphics(g, this.pane);
                        try {
                            command.setMap((IMap)this.pane.getMapEditor().getMap());
                            command.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception e) {
                            ProjectUIPlugin.log("", e);
                            if (pre) {
                                this.commands.removePre(command);
                                break block10;
                            }
                            this.commands.removePost(command);
                        }
                    } else if (pre) {
                        this.commands.removePre(command);
                    } else {
                        this.commands.removePost(command);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            ProjectUIPlugin.log("", e);
            this.commands.clearCommands();
        }
    }

    public void dispose() {
    }

    public synchronized void addDrawCommand(IDrawCommand command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.commands.add(command);
    }

    void renderStart() {
        this.commands.renderstart();
        this.renderState = 3;
    }

    void renderUpdate() {
        if ((this.renderState & 2) == 2) {
            this.commands.renderupdate();
            this.renderState = 1;
        }
    }

    void renderDone() {
        this.renderState = 4;
    }

    public ViewportPane getPane() {
        return this.pane;
    }

    private void drawGlassPane(ViewportGraphics g) {
        GlassPane glass;
        GC gc = (GC)g.getGraphics(GC.class);
        if (gc != null && (glass = this.pane.getGlass()) != null) {
            glass.draw(gc);
        }
    }

    private static class CommandList {
        IDrawCommand[] preTransform = new IMapTransformCommand[5];
        IDrawCommand[] postTransform = new IMapTransformCommand[5];
        int preTI = 0;
        int postTI = 0;
        IDrawCommand[] preNorm = new IDrawCommand[5];
        IDrawCommand[] postNorm = new IDrawCommand[5];
        int preNI = 0;
        int postNI = 0;

        private CommandList() {
        }

        synchronized IDrawCommand[] getPreCommands() {
            if (this.preNI + this.preTI == 0) {
                return new IDrawCommand[0];
            }
            IDrawCommand[] carray = new IDrawCommand[this.preNI + this.preTI];
            if (this.preTI > 0) {
                System.arraycopy(this.preTransform, 0, carray, 0, this.preTI);
            }
            if (this.preNI > 0) {
                System.arraycopy(this.preNorm, 0, carray, this.preTI, this.preNI);
            }
            return carray;
        }

        public void clearCommands() {
            IDrawCommand command;
            IDrawCommand[] iDrawCommandArray = this.preTransform;
            int n = this.preTransform.length;
            int n2 = 0;
            while (n2 < n) {
                command = iDrawCommandArray[n2];
                command.setValid(false);
                command.dispose();
                ++n2;
            }
            iDrawCommandArray = this.postTransform;
            n = this.postTransform.length;
            n2 = 0;
            while (n2 < n) {
                command = iDrawCommandArray[n2];
                command.setValid(false);
                command.dispose();
                ++n2;
            }
            this.preTransform = new IMapTransformCommand[5];
            this.postTransform = new IMapTransformCommand[5];
            this.preTI = 0;
            this.postTI = 0;
            iDrawCommandArray = this.preNorm;
            n = this.preNorm.length;
            n2 = 0;
            while (n2 < n) {
                command = iDrawCommandArray[n2];
                command.setValid(false);
                command.dispose();
                ++n2;
            }
            iDrawCommandArray = this.postNorm;
            n = this.postNorm.length;
            n2 = 0;
            while (n2 < n) {
                command = iDrawCommandArray[n2];
                command.setValid(false);
                command.dispose();
                ++n2;
            }
            this.preNorm = new IDrawCommand[5];
            this.postNorm = new IDrawCommand[5];
            this.preNI = 0;
            this.postNI = 0;
        }

        synchronized void removePost(IDrawCommand command) {
            command.setValid(false);
            int i = 0;
            while (i < this.postNI) {
                if (command == this.postNorm[i]) {
                    if (i < this.postNI - 1) {
                        System.arraycopy(this.postNorm, i + 1, this.postNorm, i, this.postNI - i - 1);
                    }
                    this.setPostNI(this.postNI - 1);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.postTI) {
                if (command == this.postTransform[i]) {
                    if (i < this.postTI - 1) {
                        System.arraycopy(this.postTransform, i + 1, this.postTransform, i, this.postTI - i - 1);
                    }
                    this.setPostTI(this.postTI - 1);
                    return;
                }
                ++i;
            }
            command.dispose();
        }

        synchronized void removePre(IDrawCommand command) {
            command.setValid(false);
            int i = 0;
            while (i < this.preNI) {
                if (command == this.preNorm[i]) {
                    if (i < this.preNI - 1) {
                        System.arraycopy(this.preNorm, i + 1, this.preNorm, i, this.preNI - i - 1);
                    }
                    this.setPreNI(this.preNI - 1);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.preTI) {
                if (command == this.preTransform[i]) {
                    if (i < this.preTI - 1) {
                        System.arraycopy(this.preTransform, i + 1, this.preTransform, i, this.preTI - i - 1);
                    }
                    this.setPreTI(this.preTI - 1);
                    return;
                }
                ++i;
            }
            command.dispose();
        }

        synchronized IDrawCommand[] getPostCommands() {
            if (this.postNI + this.postTI == 0) {
                return new IDrawCommand[0];
            }
            IDrawCommand[] carray = new IDrawCommand[this.postNI + this.postTI];
            if (this.postTI > 0) {
                System.arraycopy(this.postTransform, 0, carray, 0, this.postTI);
            }
            if (this.postNI > 0) {
                System.arraycopy(this.postNorm, 0, carray, this.postTI, this.postNI);
            }
            return carray;
        }

        synchronized void add(IDrawCommand command) {
            if (command instanceof IPreMapDrawCommand) {
                if (command instanceof IMapTransformCommand) {
                    this.preTransform = this.add(command, this.preTransform, this.preTI);
                    this.setPreTI(this.preTI + 1);
                } else {
                    this.preNorm = this.add(command, this.preNorm, this.preNI);
                    this.setPreNI(this.preNI + 1);
                }
            } else if (command instanceof IMapTransformCommand) {
                this.postTransform = this.add(command, this.postTransform, this.postTI);
                this.setPostTI(this.postTI + 1);
            } else {
                this.postNorm = this.add(command, this.postNorm, this.postNI);
                this.setPostNI(this.postNI + 1);
            }
        }

        void renderstart() {
            if (this.preNI > 0) {
                IDrawCommand[] iDrawCommandArray = this.preNorm;
                int n = this.preNorm.length;
                int n2 = 0;
                while (n2 < n) {
                    IDrawCommand command = iDrawCommandArray[n2];
                    if (command != null) {
                        command.setValid(false);
                    }
                    ++n2;
                }
                this.preNorm = new IDrawCommand[this.preNI];
                this.setPreNI(0);
            }
        }

        void renderupdate() {
            if (this.preTI > 0) {
                IDrawCommand[] iDrawCommandArray = this.preTransform;
                int n = this.preTransform.length;
                int n2 = 0;
                while (n2 < n) {
                    IDrawCommand command = iDrawCommandArray[n2];
                    if (command != null) {
                        command.setValid(false);
                    }
                    ++n2;
                }
                this.preTransform = new IDrawCommand[this.preTI];
                this.setPreTI(0);
            }
        }

        private IDrawCommand[] add(IDrawCommand command, IDrawCommand[] array, int index) {
            if (index == array.length) {
                IDrawCommand[] tmp = array;
                array = new IDrawCommand[index * 2];
                System.arraycopy(tmp, 0, array, 0, index);
            }
            array[index] = command;
            return array;
        }

        private synchronized void setPostNI(int postNI) {
            if (postNI > -1) {
                this.postNI = postNI;
            }
        }

        private synchronized void setPostTI(int postTI) {
            if (postTI > -1) {
                this.postTI = postTI;
            }
        }

        private synchronized void setPreNI(int preNI) {
            if (preNI > -1) {
                this.preNI = preNI;
            }
        }

        private synchronized void setPreTI(int preTI) {
            if (preTI > -1) {
                this.preTI = preTI;
            }
        }
    }
}

