/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.render.displayAdapter.impl;

import java.awt.Dimension;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.render.displayAdapter.MapDisplayEvent;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.EventJob;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelEvent;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class EventHandler
implements Listener {
    EventJob eventJob;
    ViewportPane pane;
    Dimension size;
    private long scheduledTime;

    public EventHandler(ViewportPane pane, EventJob eventJob) {
        this.eventJob = eventJob;
        this.pane = pane;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 5: {
                this.mouseMove(event);
                break;
            }
            case 3: {
                this.mouseDown(event);
                ProjectUIPlugin.trace("net.refractions.udig.project.ui/debug/viewport/trace", this.getClass(), "mouse down", null);
                break;
            }
            case 6: {
                this.mouseEnter(event);
                break;
            }
            case 7: {
                this.mouseExit(event);
                break;
            }
            case 32: {
                this.mouseHover(event);
                break;
            }
            case 4: {
                this.mouseUp(event);
                ProjectUIPlugin.trace("net.refractions.udig.project.ui/debug/viewport/trace", this.getClass(), "mouse up", null);
                break;
            }
            case 37: {
                this.mouseWheel(event);
                break;
            }
            case 11: {
                this.controlResized(event);
            }
        }
    }

    private void mouseWheel(Event e) {
        MapMouseWheelEvent m = new MapMouseWheelEvent(this.pane, e.x, e.y, e.stateMask, this.getButtonsDown(e), this.getButton(e.button), e.count);
        this.eventJob.fire(8, m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlResized(final Event e) {
        if (e == null) {
            return;
        }
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            this.scheduledTime = System.currentTimeMillis() + 400L;
        }
        PlatformGIS.asyncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                e.display.timerExec(500, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long l;
                        long currentTimeMillis = System.currentTimeMillis();
                        EventHandler eventHandler = EventHandler.this;
                        synchronized (eventHandler) {
                            l = EventHandler.this.scheduledTime;
                        }
                        if (l <= currentTimeMillis) {
                            (this).EventHandler.this.eventJob.fire(9, new MapDisplayEvent((IMapDisplay)(this).EventHandler.this.pane, (this).EventHandler.this.size, (this).EventHandler.this.pane.getDisplaySize()));
                            (this).EventHandler.this.size = (this).EventHandler.this.pane.getDisplaySize();
                        }
                    }
                });
            }
        }, (boolean)true);
    }

    public void mouseDoubleClick(Event e) {
        MapMouseEvent m = this.createMapMouseEvent(e);
        m = new MapMouseEvent(this.pane, m.x, m.y, m.modifiers, m.buttons | m.button, m.button);
        this.eventJob.fire(1, m);
    }

    private MapMouseEvent createMapMouseEvent(Event e) {
        return new MapMouseEvent(this.pane, e.x, e.y, e.stateMask, this.getButtonsDown(e), this.getButton(e.button));
    }

    private int getButtonsDown(Event e) {
        int button1 = (e.stateMask & 0x80000) != 0 ? 1 : -1;
        int button2 = (e.stateMask & 0x100000) != 0 ? 2 : -1;
        int button3 = (e.stateMask & 0x200000) != 0 ? 3 : -1;
        return this.getButton(button1) | this.getButton(button2) | this.getButton(button3);
    }

    private int getButton(int button) {
        int state = 0;
        if (button == 1) {
            state |= 8;
        }
        if (button == 2) {
            state |= 0x10;
        }
        if (button == 3) {
            state |= 0x20;
        }
        return state;
    }

    public void mouseDown(Event e) {
        MapMouseEvent m = this.createMapMouseEvent(e);
        m = new MapMouseEvent(this.pane, m.x, m.y, m.modifiers, m.buttons | m.button, m.button);
        this.eventJob.fire(2, m);
    }

    public void mouseUp(Event e) {
        MapMouseEvent m = this.createMapMouseEvent(e);
        if ((m.button & m.buttons) != 0) {
            m = new MapMouseEvent(m.source, m.x, m.y, m.modifiers, m.buttons ^ m.button, m.button);
        }
        this.eventJob.fire(3, m);
    }

    public void mouseMove(Event e) {
        MapMouseEvent m = this.createMapMouseEvent(e);
        if (m.buttons == 0) {
            this.eventJob.fire(4, m);
        } else {
            this.eventJob.fire(5, m);
        }
    }

    public void mouseEnter(Event e) {
        MapMouseEvent m = this.createMapMouseEvent(e);
        this.eventJob.fire(6, m);
    }

    public void mouseExit(Event e) {
        MapMouseEvent m = this.createMapMouseEvent(e);
        this.eventJob.fire(7, m);
    }

    public void mouseHover(Event e) {
        MapMouseEvent m = this.createMapMouseEvent(e);
        this.eventJob.fire(10, m);
    }
}

