/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.property.pages;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.property.pages.LayerSummary;
import net.refractions.udig.project.ui.summary.SummaryControl;
import net.refractions.udig.project.ui.summary.SummaryData;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MapSummary
extends PropertyPage
implements IWorkbenchPropertyPage {
    private String newAbstract;
    private String newName;
    private String oldAbstract;
    private String oldName;
    private SummaryData nameData;
    private SummaryData abstractData;
    private SummaryControl summaryControl;

    protected Control createContents(Composite parent) {
        Map map = (Map)this.getElement();
        ReferencedEnvelope bounds = map.getBounds(ProgressManager.instance().get(new Object[0]));
        ArrayList<SummaryData> data = new ArrayList<SummaryData>();
        String name = map.getName();
        this.nameData = new SummaryData(Messages.LayerSummary_name, name == null ? "" : name);
        this.nameData.setModifier(new NameModifier());
        data.add(this.nameData);
        this.newName = this.oldName = this.nameData.getInfo();
        String abstract1 = map.getAbstract();
        this.abstractData = new SummaryData(Messages.MapSummary_abstract, abstract1 == null ? "" : abstract1);
        this.abstractData.setModifier(new AbstractModifier());
        data.add(this.abstractData);
        this.newAbstract = this.oldAbstract = this.abstractData.getInfo();
        data.add(new SummaryData(Messages.LayerSummary_id, map.getID()));
        data.add(new SummaryData(Messages.MapSummary_mapBounds, bounds == null ? Messages.LayerSummary_unknownBounds : LayerSummary.parseBounds((Envelope)bounds)));
        data.add(new SummaryData(Messages.MapSummary_viewportBounds, LayerSummary.parseBounds((Envelope)map.getViewportModel().getBounds())));
        this.summaryControl = new SummaryControl(data);
        return this.summaryControl.createControl(parent);
    }

    protected void performApply() {
        this.summaryControl.applyEdit();
        Map map = (Map)this.getElement();
        if (!this.newName.equals(this.oldName)) {
            map.setName(this.newName);
        }
        if (!this.newAbstract.equals(this.oldAbstract)) {
            map.setAbstract(this.newAbstract);
        }
    }

    public boolean performCancel() {
        this.performDefaults();
        return super.performCancel();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        this.summaryControl.cancelEdit();
        Map map = (Map)this.getElement();
        if (!this.newAbstract.equals(this.oldAbstract)) {
            this.newAbstract = this.oldAbstract;
            this.abstractData.setInfo(this.oldAbstract);
            this.summaryControl.refresh(this.abstractData);
            map.setAbstract(this.oldAbstract);
        }
        if (!this.newName.equals(this.oldName)) {
            this.newName = this.oldName;
            this.nameData.setInfo(this.oldName);
            this.summaryControl.refresh(this.nameData);
            map.setName(this.oldName);
        }
    }

    private class AbstractModifier
    implements ICellModifier {
        private AbstractModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element == MapSummary.this.abstractData;
        }

        public Object getValue(Object element, String property) {
            if (!MapSummary.this.newAbstract.equals(MapSummary.this.oldAbstract)) {
                return MapSummary.this.newAbstract;
            }
            return ((SummaryData)element).getInfo();
        }

        public void modify(Object element, String property, Object value) {
            if (((TreeItem)element).getData() == MapSummary.this.abstractData) {
                MapSummary.this.newAbstract = (String)value;
                MapSummary.this.nameData.setInfo(MapSummary.this.newName);
                MapSummary.this.summaryControl.refresh(MapSummary.this.nameData);
            }
        }
    }

    private class NameModifier
    implements ICellModifier {
        private NameModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element == MapSummary.this.nameData;
        }

        public Object getValue(Object element, String property) {
            if (!MapSummary.this.newName.equals(MapSummary.this.oldName)) {
                return MapSummary.this.newName;
            }
            return ((SummaryData)element).getInfo();
        }

        public void modify(Object element, String property, Object value) {
            if (((TreeItem)element).getData() == MapSummary.this.nameData) {
                MapSummary.this.newName = (String)value;
                MapSummary.this.nameData.setInfo(MapSummary.this.newName);
                MapSummary.this.summaryControl.refresh(MapSummary.this.nameData);
            }
        }
    }
}

