/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.property.pages;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.summary.SummaryControl;
import net.refractions.udig.project.ui.summary.SummaryData;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LayerSummary
extends PropertyPage
implements IWorkbenchPropertyPage {
    private String newName;
    private SummaryData nameData;
    private SummaryControl summaryControl;
    private String oldName;

    protected Control createContents(Composite parent) {
        Layer layer = (Layer)this.getElement();
        CoordinateReferenceSystem layerCRS = layer.getCRS();
        ReferencedEnvelope bounds = layer.getBounds(ProgressManager.instance().get(new Object[0]), layerCRS);
        ArrayList<SummaryData> data = new ArrayList<SummaryData>();
        String name = layer.getName();
        this.nameData = new SummaryData(Messages.LayerSummary_name, name == null ? "" : name);
        this.nameData.setModifier(new NameModifier());
        data.add(this.nameData);
        this.newName = this.oldName = this.nameData.getInfo();
        data.add(new SummaryData(Messages.LayerSummary_id, layer.getID()));
        data.add(new SummaryData(Messages.LayerSummary_bounds, bounds == null ? Messages.LayerSummary_unknownBounds : LayerSummary.parseBounds((Envelope)bounds)));
        data.add(new SummaryData(Messages.LayerSummary_selection, layer.getFilter()));
        data.add(new SummaryData(Messages.LayerSummary_status, layer.getStatusMessage()));
        if (layer.getSchema() != null) {
            SimpleFeatureType schema = layer.getSchema();
            SummaryData schemaData = new SummaryData(Messages.LayerSummary_featureType, schema.getName().getLocalPart());
            SummaryData[] children = new SummaryData[schema.getAttributeCount()];
            int i = 0;
            while (i < children.length) {
                AttributeDescriptor attributeType = schema.getDescriptor(i);
                children[i] = new SummaryData(attributeType.getLocalName(), attributeType.getType().getBinding().getSimpleName());
                children[i].setParent(schemaData);
                ArrayList<SummaryData> attTypeChildren = new ArrayList<SummaryData>();
                attTypeChildren.add(new SummaryData(Messages.LayerSummary_nillable, attributeType.isNillable()));
                ((SummaryData)attTypeChildren.get(0)).setParent(children[i]);
                List restrictions = attributeType.getType().getRestrictions();
                for (Filter filter : restrictions) {
                    SummaryData summaryData = new SummaryData(Messages.LayerSummary_restriction, filter);
                    attTypeChildren.add(summaryData);
                    summaryData.setParent(children[i]);
                }
                SummaryData summaryData = new SummaryData(Messages.LayerSummary_maxOccurs, attributeType.getMaxOccurs());
                attTypeChildren.add(summaryData);
                summaryData.setParent(children[i]);
                summaryData = new SummaryData(Messages.LayerSummary_minOccurs, attributeType.getMinOccurs());
                attTypeChildren.add(summaryData);
                summaryData.setParent(children[i]);
                children[i].setChildren(attTypeChildren.toArray(new SummaryData[0]));
                ++i;
            }
            schemaData.setChildren(children);
            data.add(schemaData);
        }
        this.summaryControl = new SummaryControl(data);
        return this.summaryControl.createControl(parent);
    }

    public static String parseBounds(Envelope env) {
        String minx = LayerSummary.chopDouble(env.getMinX());
        String maxx = LayerSummary.chopDouble(env.getMaxX());
        String miny = LayerSummary.chopDouble(env.getMinY());
        String maxy = LayerSummary.chopDouble(env.getMaxY());
        return "(" + minx + "," + miny + ") (" + maxx + "," + maxy + ") ";
    }

    private static String chopDouble(double d) {
        String s = String.valueOf(d);
        int end = s.indexOf(46) + 2;
        while (end > s.length()) {
            --end;
        }
        return s.substring(0, end);
    }

    protected void performApply() {
        this.summaryControl.applyEdit();
        Layer layer = (Layer)this.getElement();
        if (!this.newName.equals(this.oldName)) {
            layer.setName(this.newName);
        }
    }

    public boolean performCancel() {
        this.performDefaults();
        return super.performCancel();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        this.summaryControl.cancelEdit();
        Layer layer = (Layer)this.getElement();
        if (!this.newName.equals(this.oldName)) {
            this.newName = this.oldName;
            this.nameData.setInfo(this.oldName);
            this.summaryControl.refresh(this.nameData);
            layer.setName(this.oldName);
        }
    }

    private class NameModifier
    implements ICellModifier {
        private NameModifier() {
        }

        public boolean canModify(Object element, String property) {
            return element == LayerSummary.this.nameData;
        }

        public Object getValue(Object element, String property) {
            if (!LayerSummary.this.newName.equals(LayerSummary.this.oldName)) {
                return LayerSummary.this.newName;
            }
            return ((SummaryData)element).getInfo();
        }

        public void modify(Object element, String property, Object value) {
            if (((TreeItem)element).getData() == LayerSummary.this.nameData) {
                LayerSummary.this.newName = (String)value;
                LayerSummary.this.nameData.setInfo(LayerSummary.this.newName);
                LayerSummary.this.summaryControl.refresh(LayerSummary.this.nameData);
            }
        }
    }
}

