/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.property.pages;

import net.miginfocom.swt.MigLayout;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.ui.filter.FilterInput;
import net.refractions.udig.ui.filter.FilterViewer;
import net.refractions.udig.ui.filter.IFilterViewer;
import net.refractions.udig.ui.properties.UDIGPropertyPage;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.geotools.data.Query;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class LayerQueryPropertyPage
extends UDIGPropertyPage
implements IWorkbenchPropertyPage {
    private FilterViewer filter;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            LayerQueryPropertyPage.this.setApplyButton();
        }
    };

    protected Control createContents(Composite parent) {
        Layer layer = (Layer)this.getElement(Layer.class);
        SimpleFeatureType schema = layer.getSchema();
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new MigLayout("insets panel", "[][fill]", "[fill][]"));
        Label label = new Label(page, 4);
        label.setText("Data Filter");
        label.setLayoutData((Object)"cell 0 0,aligny top, gapx 0 unrelated");
        ControlDecoration decoration = new ControlDecoration((Control)label, 131200);
        this.filter = new FilterViewer(page, 2);
        this.filter.getControl().setLayoutData((Object)"cell 1 0,grow,width 200:100%:100%,height 60:100%:100%");
        FilterInput input = new FilterInput();
        input.setFeedback(decoration);
        input.setRequired(false);
        this.filter.setInput((Object)input);
        this.loadLayer();
        this.listen(true);
        return page;
    }

    public void listen(boolean listen) {
        if (listen) {
            this.filter.addSelectionChangedListener(this.selectionListener);
        } else {
            this.filter.removeSelectionChangedListener(this.selectionListener);
        }
    }

    public boolean performOk() {
        this.saveLayer();
        return super.performOk();
    }

    protected void performApply() {
        this.saveLayer();
        super.performApply();
    }

    protected void performDefaults() {
        this.loadLayer();
        super.performDefaults();
    }

    Filter getDataQueryFilter() {
        Layer layer = (Layer)this.getElement(Layer.class);
        if (layer != null) {
            StyleBlackboard blackboard = layer.getStyleBlackboard();
            Object dataQuery = blackboard.get("net.refractions.udig.project.view");
            if (dataQuery instanceof Filter) {
                return (Filter)dataQuery;
            }
            if (dataQuery instanceof Query) {
                Query query = (Query)dataQuery;
                return query.getFilter();
            }
        }
        return Filter.INCLUDE;
    }

    protected void setApplyButton() {
        Filter current;
        Filter stored = this.getDataQueryFilter();
        boolean changed = !IFilterViewer.same((Filter)stored, (Filter)(current = this.filter.getFilter()));
        this.getApplyButton().setEnabled(changed);
        this.getDefaultsButton().setEnabled(changed);
    }

    private void saveLayer() {
        Layer layer;
        Filter current;
        Filter stored = this.getDataQueryFilter();
        if (!IFilterViewer.same((Filter)stored, (Filter)(current = this.filter.getFilter())) && (layer = (Layer)this.getElement(Layer.class)) != null) {
            StyleBlackboard blackboard = layer.getStyleBlackboard();
            blackboard.put("net.refractions.udig.project.view", (Object)current);
            layer.refresh(null);
        }
    }

    private void loadLayer() {
        Layer layer = (Layer)this.getElement(Layer.class);
        SimpleFeatureType schema = layer != null ? layer.getSchema() : null;
        this.filter.getInput().setSchema(schema);
        boolean enabled = schema != null;
        this.filter.getControl().setEnabled(enabled);
        Filter stored = this.getDataQueryFilter();
        this.filter.setFilter(stored);
    }
}

