/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.properties;

import java.util.ArrayList;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.properties.SchemaEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.geotools.data.FeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class SchemaDescriptor
extends PropertyDescriptor
implements IPropertySource {
    private IPropertyDescriptor[] descriptors;
    private SimpleFeatureType type;

    public SchemaDescriptor(Object id, String name, FeatureSource<SimpleFeatureType, SimpleFeature> source) {
        super(id, name);
        this.type = (SimpleFeatureType)source.getSchema();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new SchemaEditor(parent, this.type);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            ArrayList<PropertyDescriptor> desc = new ArrayList<PropertyDescriptor>();
            AttributeDescriptor[] attrs = this.type.getAttributeDescriptors().toArray(new AttributeDescriptor[0]);
            int i = 0;
            while (i < attrs.length) {
                String name = attrs[i].getLocalName().toLowerCase();
                name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
                PropertyDescriptor d = new PropertyDescriptor((Object)i, name);
                if (attrs[i] instanceof GeometryDescriptor) {
                    d.setCategory(Messages.ScemaDescriptor_geometry);
                } else {
                    d.setCategory(Messages.ScemaDescriptor_attributeTypes);
                }
                desc.add(d);
                ++i;
            }
            this.descriptors = new IPropertyDescriptor[desc.size()];
            desc.toArray(this.descriptors);
        }
        IPropertyDescriptor[] c = new IPropertyDescriptor[this.descriptors.length];
        System.arraycopy(this.descriptors, 0, c, 0, c.length);
        return c;
    }

    public Object getPropertyValue(Object id) {
        int i = (Integer)id;
        String name = this.type.getDescriptor(i).getType().getBinding().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

