/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.properties;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class GeomPropertySource
implements IPropertySource2 {
    private static final String TYPE = "TYPE";
    private static final String AREA = "AREA";
    private static final String LENGTH = "LENGTH";
    private static final String GEOM = "GEOM";
    private Geometry geom;
    private final Geometry original;
    private final IPropertyDescriptor[] propertyDescriptors;

    public GeomPropertySource(Geometry geometry) {
        this.geom = geometry;
        this.original = geometry;
        this.propertyDescriptors = new IPropertyDescriptor[3];
        this.propertyDescriptors[0] = new PropertyDescriptor((Object)new ID(AREA), Messages.GeomPropertySource_area);
        this.propertyDescriptors[1] = new PropertyDescriptor((Object)new ID(LENGTH), Messages.GeomPropertySource_length);
        this.propertyDescriptors[2] = new TextPropertyDescriptor((Object)new ID(GEOM), Messages.GeomPropertySource_WKT);
    }

    public Object getEditableValue() {
        return this.geom;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] c = new IPropertyDescriptor[this.propertyDescriptors.length];
        System.arraycopy(this.propertyDescriptors, 0, c, 0, c.length);
        return c;
    }

    public Object getPropertyValue(Object idObject) {
        ID id = (ID)idObject;
        if (id.id == TYPE) {
            return this.geom.getGeometryType();
        }
        if (id.id == AREA) {
            return String.valueOf(this.geom.getArea());
        }
        if (id.id == LENGTH) {
            return String.valueOf(this.geom.getLength());
        }
        if (id.id == GEOM) {
            return this.geomToText();
        }
        return null;
    }

    private Object geomToText() {
        WKTWriter writer = new WKTWriter();
        String text = writer.write(this.geom);
        text = text.replaceAll("[\\n\\r\\t]", " ");
        return text;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
        this.geom = this.original;
    }

    public void setPropertyValue(Object idObject, Object value) {
        ID id = (ID)idObject;
        if (id.id == GEOM) {
            WKTReader reader = new WKTReader();
            try {
                this.geom = reader.read((String)value);
            }
            catch (ParseException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
    }

    public boolean isPropertyResettable(Object id) {
        return true;
    }

    static class ID {
        String id;

        ID(String id) {
            this.id = id;
        }
    }
}

