/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.dragdrop;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectElement;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.ui.IDropAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MoveProjectElement
extends IDropAction {
    public boolean accept() {
        HashSet<ProjectElement> elements = new HashSet<ProjectElement>(this.toProjectElements());
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            ProjectElement projectElement = (ProjectElement)iterator.next();
            if (!this.getDestination().equals(projectElement.getProject())) continue;
            iterator.remove();
        }
        return elements != null && !elements.isEmpty();
    }

    private Collection<ProjectElement> toProjectElements() {
        if (this.getData() instanceof ProjectElement) {
            ProjectElement element = (ProjectElement)this.getData();
            return Collections.singleton(element);
        }
        if (this.getData() instanceof EObject) {
            EObject eobj = (EObject)this.getData();
            while (eobj != null && !(eobj instanceof ProjectElement)) {
                eobj = eobj.eContainer();
            }
            if (eobj instanceof ProjectElement) {
                return Collections.singleton((ProjectElement)eobj);
            }
            return null;
        }
        Object[] array = null;
        if (this.getData() instanceof Collection) {
            Collection data = (Collection)this.getData();
            array = data.toArray();
        }
        if (this.getData().getClass().isArray()) {
            array = (Object[])this.getData();
        }
        if (array != null) {
            HashSet<ProjectElement> elements = new HashSet<ProjectElement>();
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ProjectElement) {
                    ProjectElement element = (ProjectElement)object;
                    elements.add(element);
                }
                if (object instanceof EObject) {
                    EObject eobj = (EObject)object;
                    while (eobj != null && !(eobj instanceof ProjectElement)) {
                        eobj = eobj.eContainer();
                    }
                    if (eobj instanceof ProjectElement) {
                        elements.add((ProjectElement)eobj);
                    }
                }
                ++n2;
            }
            if (!elements.isEmpty()) {
                return elements;
            }
        }
        return null;
    }

    public void perform(IProgressMonitor monitor) {
        Project destination;
        Collection<ProjectElement> elements = this.toProjectElements();
        Collection<Project> projects = this.collectAffectedProjects(elements, destination = (Project)this.getDestination());
        Collection messages = ProjectPlugin.saveProjects(projects);
        if (!messages.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error saving projects", (String)"An error occurred while attempting to save projects.  Please verify you have write access to the project files and no other applications have locked the files.");
            return;
        }
        Collection<ProjectElement> allElements = this.removeFromOldProjects(elements);
        destination.getElementsInternal().addAll(allElements);
        Collection errors = ProjectPlugin.saveProjects(projects);
        if (!errors.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error saving projects", (String)"An error occurred while attempting to save projects.  Please verify you have write access to the project files and no other applications have locked the files.");
            return;
        }
    }

    private Collection<ProjectElement> removeFromOldProjects(Collection<ProjectElement> elements) {
        HashSet<ProjectElement> all = new HashSet<ProjectElement>();
        for (ProjectElement projectElement : elements) {
            Project projectInternal = projectElement.getProjectInternal();
            all.add(projectElement);
            List children = projectElement.getElements(ProjectElement.class);
            all.addAll(this.removeFromOldProjects(children));
            if (projectInternal == null) continue;
            projectInternal.getElementsInternal().remove(projectElement);
        }
        return all;
    }

    private Collection<Project> collectAffectedProjects(Collection<ProjectElement> elements, Project destination) {
        HashSet<Project> projects = new HashSet<Project>();
        projects.add(destination);
        for (ProjectElement projectElement : elements) {
            Project projectInternal = projectElement.getProjectInternal();
            if (projectInternal != null) {
                projects.add(projectInternal);
            }
            Collection<Project> affectedProjects = this.collectAffectedProjects(projectElement.getElements(ProjectElement.class), destination);
            projects.addAll(affectedProjects);
        }
        return projects;
    }
}

