/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.dragdrop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.commands.AddLayersCommand;
import net.refractions.udig.project.internal.commands.DeleteLayersCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.LayersView;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.ui.IDropAction;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveLayerDropAction
extends IDropAction {
    public boolean accept() {
        Layer layer = MoveLayerDropAction.toLayer(this);
        if (layer == null) {
            return false;
        }
        Object destination2 = this.getDestination();
        if (destination2 instanceof LayersView || destination2 instanceof MapEditorPart) {
            destination2 = ApplicationGIS.getActiveMap();
        }
        return layer.getMap() != destination2;
    }

    static Layer toLayer(IDropAction action) {
        Layer layer;
        if (action.getData() instanceof Layer) {
            layer = (Layer)action.getData();
        } else {
            Object[] layers = (Object[])action.getData();
            layer = (Layer)layers[0];
            Object[] objectArray = layers;
            int n = layers.length;
            int n2 = 0;
            while (n2 < n) {
                Object layer2 = objectArray[n2];
                if (((ILayer)layer2).getMap() != layer.getMap()) {
                    return null;
                }
                ++n2;
            }
        }
        return layer;
    }

    public void perform(IProgressMonitor monitor) {
        Object data2 = this.getData();
        Object map = this.getDestination() instanceof LayersView || this.getDestination() instanceof MapEditorPart ? ApplicationGIS.getActiveMap() : (Map)this.getDestination();
        Collection<Layer> layers = MoveLayerDropAction.toCollection(data2);
        map.sendCommandASync((MapCommand)new AddLayersCommand(layers));
        layers.iterator().next().getMap().sendCommandASync((MapCommand)new DeleteLayersCommand((ILayer[])layers.toArray(new Layer[0])));
    }

    public static Collection<Layer> toCollection(Object data2) {
        Collection<Object> layers;
        if (data2 instanceof Layer) {
            layers = Collections.singleton((Layer)data2);
        } else {
            Object[] array;
            layers = new ArrayList();
            Object[] objectArray = array = (Object[])data2;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Layer) {
                    layers.add((Layer)object);
                }
                ++n2;
            }
        }
        return layers;
    }
}

