/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.dragdrop;

import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.ui.IDropAction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

public class DropFilterAction
extends IDropAction {
    public boolean accept() {
        return true;
    }

    public void perform(IProgressMonitor monitor) {
        Layer destinationLayer;
        IMap destinationMap;
        if (this.getDestination() instanceof IMap) {
            destinationMap = (IMap)this.getDestination();
            destinationLayer = (Layer)destinationMap.getEditManager().getSelectedLayer();
        } else if (this.getDestination() instanceof Layer) {
            destinationLayer = (Layer)this.getDestination();
            destinationMap = destinationLayer.getMap();
        } else {
            return;
        }
        if (this.getData() instanceof IAdaptable) {
            ILayer layer = (ILayer)((IAdaptable)this.getData()).getAdapter(ILayer.class);
            Filter filter = (Filter)((IAdaptable)this.getData()).getAdapter(Filter.class);
            if (filter == null) {
                SimpleFeature feature = (SimpleFeature)((IAdaptable)this.getData()).getAdapter(SimpleFeature.class);
                FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
                if (feature != null) {
                    filter = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)feature.getID()));
                } else {
                    return;
                }
            }
            if (layer == null) {
                this.setSelection(filter == null ? (Filter)this.getData() : filter, destinationLayer, monitor);
            } else {
                UndoableMapCommand c = EditCommandFactory.getInstance().createCopyFeaturesCommand(layer, filter, (ILayer)destinationLayer);
                destinationMap.sendCommandASync((MapCommand)c);
            }
        } else {
            this.setSelection((Filter)this.getData(), destinationLayer, monitor);
        }
    }

    private void setSelection(Filter filter, Layer layer, IProgressMonitor monitor) {
        monitor.beginTask(Messages.DropFilterAction_taskname, 2);
        monitor.worked(1);
        layer.setFilter(filter);
        monitor.done();
    }
}

