/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands.draw;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import net.refractions.udig.ui.graphics.SWTGraphics;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public class DrawShapeCommand
extends AbstractDrawCommand {
    private Path path = null;
    private Shape shape = null;
    private Color paint = null;
    private int style = -1;
    private int width;
    private Color fill;

    public DrawShapeCommand() {
        this(null, Color.BLACK, 1, 1);
    }

    public DrawShapeCommand(Shape shape, Color color, int lineStyle, int lineWidth) {
        this.setShape(shape);
        this.paint = color;
        this.style = lineStyle;
        this.width = lineWidth;
    }

    public void run(IProgressMonitor monitor) {
        if (this.shape == null) {
            return;
        }
        if (this.fill != null) {
            this.graphics.setColor(this.fill);
            this.graphics.fill(this.shape);
        }
        if (this.paint != null) {
            this.graphics.setColor(this.paint);
        }
        if (this.style > -1) {
            this.graphics.setStroke(this.style, this.width);
        }
        this.doDraw();
    }

    private void doDraw() {
        if (this.shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)this.shape;
            this.graphics.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            return;
        }
        if (this.shape instanceof Ellipse2D) {
            Ellipse2D ellipse = (Ellipse2D)this.shape;
            this.graphics.drawOval((int)ellipse.getMinX(), (int)ellipse.getMinY(), (int)ellipse.getWidth(), (int)ellipse.getHeight());
            return;
        }
        if (this.graphics instanceof SWTGraphics) {
            if (this.path == null || this.path.isDisposed()) {
                this.path = AWTSWTImageUtils.createPath((PathIterator)this.shape.getPathIterator(new AffineTransform()), (Device)Display.getCurrent());
            }
            this.graphics.drawPath(this.path);
        } else {
            this.graphics.draw(this.shape);
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Color paint) {
        this.paint = paint;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.path = null;
    }

    public int getLineStyle() {
        return this.style;
    }

    public int getLineWidth() {
        return this.width;
    }

    public void setStroke(int lineStyle, int lineWidth) {
        this.style = lineStyle;
        this.width = lineWidth;
    }

    public void setFill(Color fillColor) {
        this.fill = fillColor;
    }

    @Override
    public Rectangle getValidArea() {
        if (this.shape == null) {
            return null;
        }
        return this.shape.getBounds();
    }

    @Override
    public void setValid(boolean valid) {
        super.setValid(valid);
    }

    @Override
    public void dispose() {
        if (this.path != null && !this.path.isDisposed()) {
            this.path.dispose();
        }
    }
}

