/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands.draw;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.ui.Drawing;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import net.refractions.udig.ui.graphics.SWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class DrawFeatureCommand
extends AbstractDrawCommand {
    private SimpleFeature feature;
    private static final Map<MathTransformKey, MathTransform> mtCache = new ConcurrentHashMap<MathTransformKey, MathTransform>();
    private Drawing drawing = Drawing.create();
    private CoordinateReferenceSystem featureCRS;
    Symbolizer[] syms;
    private Color color = Color.ORANGE;
    private MathTransform mt;
    private Image image;
    private boolean errorReported;
    private static final boolean BUFFER_READY = false;

    public DrawFeatureCommand(SimpleFeature feature, ILayer layer) throws IOException {
        this(feature, layer.getCRS());
    }

    public DrawFeatureCommand(SimpleFeature feature, CoordinateReferenceSystem crs) {
        this.feature = feature;
        this.featureCRS = crs == null ? DefaultGeographicCRS.WGS84 : crs;
    }

    public DrawFeatureCommand(SimpleFeature feature) {
        this(feature, feature.getFeatureType().getCoordinateReferenceSystem());
    }

    public void preRender() {
    }

    private void renderInternal() {
        ReferencedEnvelope envelope;
        if (this.syms == null) {
            this.syms = Drawing.getSymbolizers(((Geometry)this.feature.getDefaultGeometry()).getClass(), (Color)this.color, (boolean)false);
        }
        MathTransform mt = this.getMathTransform(this.featureCRS);
        AffineTransform toScreen = this.getMap().getViewportModel().worldToScreenTransform();
        try {
            ReferencedEnvelope bounds = new ReferencedEnvelope(this.feature.getBounds());
            envelope = bounds.transform(this.getMap().getViewportModel().getCRS(), true);
        }
        catch (Exception exception) {
            envelope = new ReferencedEnvelope(this.feature.getBounds());
        }
        double[] screenbounds = new double[]{envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY()};
        toScreen.transform(screenbounds, 0, screenbounds, 0, 2);
        int width = (int)Math.abs(screenbounds[2] - screenbounds[0]);
        int height = (int)Math.abs(screenbounds[3] - screenbounds[1]);
        this.image = AWTSWTImageUtils.createDefaultImage((Display)Display.getDefault(), (int)width, (int)height);
        SWTGraphics graphics = new SWTGraphics(this.image, Display.getDefault());
        this.drawing.drawFeature((ViewportGraphics)graphics, this.feature, this.getMap().getViewportModel().worldToScreenTransform((Envelope)envelope, new Dimension(width, height)), false, this.syms, mt);
        graphics.dispose();
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.syms == null) {
            this.syms = Drawing.getSymbolizers(((Geometry)this.feature.getDefaultGeometry()).getClass(), (Color)this.color, (boolean)false);
        }
        MathTransform mt = this.getMathTransform(this.featureCRS);
        this.drawing.drawFeature(this.graphics, this.feature, this.getMap().getViewportModel().worldToScreenTransform(), false, this.syms, mt);
    }

    private MathTransform getMathTransform(CoordinateReferenceSystem featureCRS) {
        MathTransformKey key = new MathTransformKey(featureCRS, this.getMap().getViewportModel().getCRS());
        this.mt = mtCache.get(key);
        if (this.mt == null) {
            try {
                this.mt = CRS.findMathTransform((CoordinateReferenceSystem)featureCRS, (CoordinateReferenceSystem)this.getMap().getViewportModel().getCRS(), (boolean)true);
            }
            catch (Exception exception) {
                this.mt = null;
            }
            mtCache.put(key, this.mt);
        }
        return this.mt;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setSymbolizers(Symbolizer[] syms) {
        if (syms == null) {
            this.syms = new Symbolizer[0];
        } else {
            this.syms = new Symbolizer[syms.length];
            System.arraycopy(syms, 0, this.syms, 0, this.syms.length);
        }
    }

    @Override
    public Rectangle getValidArea() {
        if (this.feature != null) {
            try {
                ReferencedEnvelope bounds = new ReferencedEnvelope(this.feature.getBounds()).transform(this.getMap().getViewportModel().getCRS(), true);
                double[] points = new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()};
                this.getMap().getViewportModel().worldToScreenTransform().transform(points, 0, points, 0, 2);
                return new Rectangle((int)points[0], (int)points[1], (int)Math.abs(points[2] - points[0]), (int)Math.abs(points[3] - points[1]));
            }
            catch (TransformException e) {
                if (!this.errorReported) {
                    this.errorReported = true;
                    ProjectUIPlugin.log("error calculating valid area, this will not be reported again", e);
                }
                return null;
            }
            catch (MismatchedDimensionException e) {
                if (!this.errorReported) {
                    this.errorReported = true;
                    ProjectUIPlugin.log("error calculating valid area, this will not be reported again", e);
                }
                return null;
            }
            catch (FactoryException e) {
                if (!this.errorReported) {
                    this.errorReported = true;
                    ProjectUIPlugin.log("error calculating valid area, this will not be reported again", e);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void setValid(boolean valid) {
        super.setValid(valid);
        if (!valid) {
            this.dispose();
        }
    }

    protected void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
    }

    private static class MathTransformKey {
        final CoordinateReferenceSystem from;
        final CoordinateReferenceSystem to;

        protected MathTransformKey(CoordinateReferenceSystem from, CoordinateReferenceSystem to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MathTransformKey other = (MathTransformKey)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

