/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.commands;

import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.core.StaticProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SetLayerCRSCommand
extends AbstractCommand
implements UndoableMapCommand {
    public static final String NAME = Messages.SetLayerCRSCommand_name;
    private StaticProvider<ILayer> provider;
    private Layer layer;
    private CoordinateReferenceSystem crs;
    private CoordinateReferenceSystem old;
    private ReferencedEnvelope oldBounds = null;

    public SetLayerCRSCommand(ILayer layer, CoordinateReferenceSystem crs) {
        this.provider = new StaticProvider((Object)layer);
        this.crs = crs;
    }

    public String getName() {
        return NAME;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(NAME, 1);
        if (this.layer == null) {
            this.layer = (Layer)this.provider.get(new Object[0]);
        }
        this.old = this.layer.getCRS(monitor);
        monitor.setTaskName(NAME);
        this.layer.setCRS(this.crs);
        ViewportModel viewportModel = this.layer.getMapInternal().getViewportModelInternal();
        ReferencedEnvelope bounds = this.layer.getMapInternal().getViewportModel().getBounds();
        if (this.layer.getMapInternal().getMapLayers().size() == 1 && !bounds.intersects((Envelope)this.layer.getBounds(monitor, viewportModel.getCRS()))) {
            this.oldBounds = bounds;
            viewportModel.zoomToExtent();
        }
        monitor.done();
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        String name = Messages.SetLayerCRSCommand_undoTask;
        monitor.beginTask(name, 1);
        Layer layer = (Layer)this.provider.get(new Object[0]);
        layer.setCRS(this.old);
        if (this.oldBounds != null) {
            ViewportModel viewportModel = layer.getMapInternal().getViewportModelInternal();
            viewportModel.setBounds(this.oldBounds);
        }
        monitor.done();
    }
}

