/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.aoi;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MapCrsAOIStrategy
extends IAOIStrategy {
    private static String name = "Map CRS";

    public ReferencedEnvelope getExtent() {
        IMap currentMap = ApplicationGIS.getActiveMap();
        return MapCrsAOIStrategy.calcualteExtent(currentMap);
    }

    public static ReferencedEnvelope calcualteExtent(IMap currentMap) throws MismatchedDimensionException {
        if (!currentMap.equals(ApplicationGIS.NO_MAP)) {
            GeographicBoundingBox worldBounds;
            CoordinateReferenceSystem worldCRS = currentMap.getViewportModel().getCRS();
            try {
                String code;
                if ((worldCRS.getIdentifiers() == null || worldCRS.getIdentifiers().isEmpty()) && (code = CRS.lookupIdentifier((IdentifiedObject)worldCRS, (boolean)true)) != null) {
                    worldCRS = CRS.decode((String)code);
                }
            }
            catch (FactoryException factoryException) {}
            ReferencedEnvelope extent = null;
            org.opengis.geometry.Envelope envelope = CRS.getEnvelope((CoordinateReferenceSystem)worldCRS);
            if (envelope instanceof BoundingBox && (extent = ReferencedEnvelope.reference((BoundingBox)((BoundingBox)envelope))).getCoordinateReferenceSystem() != worldCRS) {
                return null;
            }
            if ((extent == null || extent.isEmpty() || extent.isNull()) && (worldBounds = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)worldCRS)) != null) {
                ReferencedEnvelope testGeo = new ReferencedEnvelope(worldBounds.getWestBoundLongitude(), worldBounds.getEastBoundLongitude(), worldBounds.getNorthBoundLatitude(), worldBounds.getSouthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                try {
                    extent = testGeo.transform(worldCRS, true);
                }
                catch (TransformException transformException) {
                    extent = null;
                }
                catch (FactoryException factoryException) {
                    extent = null;
                }
            }
            if (extent == null || extent.isEmpty() || extent.isNull()) {
                return null;
            }
            return extent;
        }
        return null;
    }

    public Geometry getGeometry() {
        ReferencedEnvelope extent = this.getExtent();
        if (extent != null) {
            return new GeometryFactory().toGeometry((Envelope)extent);
        }
        return null;
    }

    public CoordinateReferenceSystem getCrs() {
        IMap currentMap = ApplicationGIS.getActiveMap();
        if (!currentMap.equals(ApplicationGIS.NO_MAP)) {
            return currentMap.getViewportModel().getCRS();
        }
        return null;
    }

    public String getName() {
        return name;
    }
}

