/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.adapters;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import net.refractions.udig.project.UDIGAdaptableDecorator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class UDIGAdapterSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private ISelectionProvider provider;
    CopyOnWriteArrayList<ISelectionChangedListener> listeners = new CopyOnWriteArrayList();

    public UDIGAdapterSelectionProvider(ISelectionProvider provider) {
        this.provider = provider;
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        ISelection selection = this.provider.getSelection();
        ArrayList<Object> newSelection = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)selection) {
                if (object instanceof IAdaptable) {
                    newSelection.add(object);
                    continue;
                }
                Object adaptable = Platform.getAdapterManager().getAdapter(object, IAdaptable.class);
                if (adaptable == null) {
                    adaptable = object;
                }
                newSelection.add(adaptable);
            }
            selection = new StructuredSelection(newSelection);
        }
        return selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void setSelection(ISelection selection) {
        ArrayList<Object> newSelection = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            for (Object object : (IStructuredSelection)selection) {
                if (object instanceof UDIGAdaptableDecorator) {
                    newSelection.add(((UDIGAdaptableDecorator)object).getObject());
                    continue;
                }
                newSelection.add(object);
            }
            selection = new StructuredSelection(newSelection);
        }
        this.provider.setSelection(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        final SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (final ISelectionChangedListener listener : this.listeners) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    listener.selectionChanged(newEvent);
                }
            });
        }
    }

    public ISelectionProvider testGetProvider() {
        return this.provider;
    }
}

