/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.adapters;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.AdaptableFeature;
import net.refractions.udig.project.ui.internal.adapters.FeatureTableProvider;
import net.refractions.udig.project.ui.internal.adapters.FeatureViewerProvider;
import net.refractions.udig.project.ui.internal.properties.FeaturePropertySource;
import net.refractions.udig.project.ui.internal.properties.GeomPropertySource;
import net.refractions.udig.project.ui.internal.properties.IGeoResourcePropertySource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureAdapterFactory
implements IAdapterFactory {
    static final Class[] adapters = new Class[]{IPropertySource2.class, IPropertySource.class, ITreeContentProvider.class, ILabelProvider.class, IContentProvider.class, IStructuredContentProvider.class, ITableLabelProvider.class, ITableColorProvider.class, FeatureTableProvider.class, IAdaptable.class};
    static final Class[] adaptableClasses = new Class[]{SimpleFeature.class, Coordinate.class, Coordinate[].class, Geometry.class, IGeoResource.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (!this.canAdaptTo(adapterType) || !this.canAdapt(adaptableObject)) {
            return null;
        }
        if (IPropertySource.class.isAssignableFrom(adapterType)) {
            if (SimpleFeature.class.isAssignableFrom(adaptableObject.getClass())) {
                return this.createFeaturePropertySource(adaptableObject);
            }
            if (Geometry.class.isAssignableFrom(adaptableObject.getClass())) {
                return this.createGeometryPropertySource(adaptableObject);
            }
            if (IGeoResource.class.isAssignableFrom(adaptableObject.getClass())) {
                return this.createServicePropertySource(adaptableObject);
            }
        }
        if (ITableColorProvider.class.isAssignableFrom(adapterType) || ITableLabelProvider.class.isAssignableFrom(adapterType) || FeatureTableProvider.class.isAssignableFrom(adapterType)) {
            return new FeatureTableProvider();
        }
        if (IContentProvider.class.isAssignableFrom(adapterType) || ILabelProvider.class.isAssignableFrom(adapterType)) {
            return new FeatureViewerProvider();
        }
        if (IAdaptable.class.isAssignableFrom(adapterType) && SimpleFeature.class.isAssignableFrom(adaptableObject.getClass())) {
            return new AdaptableFeature((SimpleFeature)adaptableObject);
        }
        return null;
    }

    public boolean canAdapt(Object adaptableObject) {
        int i = 0;
        while (i < adaptableClasses.length) {
            if (adaptableClasses[i].isAssignableFrom(adaptableObject.getClass())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canAdaptTo(Class adapterType) {
        int i = 0;
        while (i < adapters.length) {
            if (adapterType.isAssignableFrom(adapters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IPropertySource2 createFeaturePropertySource(Object adaptableObject) {
        return new FeaturePropertySource((SimpleFeature)adaptableObject);
    }

    private IPropertySource2 createGeometryPropertySource(Object adaptableObject) {
        return new GeomPropertySource((Geometry)adaptableObject);
    }

    private IPropertySource2 createServicePropertySource(Object adaptableObject) {
        return new IGeoResourcePropertySource((IGeoResource)adaptableObject);
    }

    public Class[] getAdapterList() {
        Class[] c = new Class[adapters.length];
        System.arraycopy(adapters, 0, c, 0, c.length);
        return c;
    }
}

