/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.util.Iterator;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.internal.render.impl.ScaleUtils;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ZoomToLayer
extends ActionDelegate
implements IViewActionDelegate {
    IStructuredSelection selection;

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            this.selection = (IStructuredSelection)selection;
        }
        catch (Exception exception) {}
    }

    public void runWithEvent(IAction action, Event event) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, (IRunnableWithProgress)new ZoomRunnable());
        }
        catch (Exception e) {
            ProjectUIPlugin.log(null, e);
        }
    }

    public void init(IViewPart view) {
    }

    private final class ZoomRunnable
    implements IRunnableWithProgress {
        private ZoomRunnable() {
        }

        public void run(IProgressMonitor monitor) {
            Map map = ((Layer)ZoomToLayer.this.selection.getFirstElement()).getMapInternal();
            ReferencedEnvelope bounds = new ReferencedEnvelope(map.getViewportModel().getCRS());
            Coordinate mapCenter = map.getViewportModel().getCenter();
            CoordinateReferenceSystem mapCRS = map.getViewportModel().getCRS();
            Iterator iter = ZoomToLayer.this.selection.iterator();
            while (iter.hasNext()) {
                try {
                    Layer layer = (Layer)iter.next();
                    if (layer.getMap() != map) continue;
                    ReferencedEnvelope bbox = null;
                    bbox = layer.getBounds(monitor, mapCRS);
                    if (bbox == null || bbox.isNull()) continue;
                    ReferencedEnvelope fitToScale = ScaleUtils.fitToMinAndMax((ReferencedEnvelope)bbox, (ILayer)layer);
                    bounds.expandToInclude((Envelope)this.translateToCenter(fitToScale, bbox, mapCenter));
                }
                catch (Exception e) {
                    ProjectUIPlugin.log("exception getting bounds", e);
                }
            }
            if (!bounds.isNull()) {
                map.sendCommandASync((MapCommand)new SetViewportBBoxCommand(bounds));
            }
        }

        private ReferencedEnvelope translateToCenter(ReferencedEnvelope fitToScale, ReferencedEnvelope layerBounds, Coordinate mapCenter) {
            if (fitToScale.equals((Object)layerBounds) || !layerBounds.covers(mapCenter)) {
                return layerBounds;
            }
            Coordinate layerCenter = fitToScale.centre();
            double deltaX = mapCenter.x - layerCenter.x;
            double deltaY = mapCenter.y - layerCenter.y;
            double maxNegX = layerBounds.getMinX() - fitToScale.getMinX();
            double maxNegY = layerBounds.getMinY() - fitToScale.getMinY();
            double maxPosX = layerBounds.getMaxX() - fitToScale.getMaxX();
            double maxPosY = layerBounds.getMaxY() - fitToScale.getMaxY();
            if (deltaX < maxNegX) {
                deltaX = maxNegX;
            } else if (deltaX > maxPosX) {
                deltaX = maxPosX;
            }
            if (deltaY < maxNegY) {
                deltaY = maxNegY;
            } else if (deltaY > maxPosY) {
                deltaY = maxPosY;
            }
            fitToScale.translate(deltaX, deltaY);
            return fitToScale;
        }
    }
}

