/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.impl.MapImpl;
import net.refractions.udig.project.ui.wizard.export.project.ExportProjectUtils;
import net.refractions.udig.ui.ProgressManager;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SaveAsProject
implements IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchWindow window;
    private Project project;

    public void run(IAction action) {
        Object firstElement = this.selection.getFirstElement();
        if (firstElement instanceof MapImpl) {
            MapImpl map = (MapImpl)firstElement;
            this.project = (Project)map.getProject();
        }
        if (firstElement instanceof Project) {
            this.project = (Project)firstElement;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = null;
                shell = SaveAsProject.this.window == null || SaveAsProject.this.window.getShell() == null ? Display.getDefault().getActiveShell() : SaveAsProject.this.window.getShell();
                DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
                fileDialog.setMessage(Messages.SaveProject_Destination);
                String path = fileDialog.open();
                URI origURI = SaveAsProject.this.project.eResource().getURI();
                File file = new File(origURI.toFileString());
                String destinationUdigFolder = String.valueOf(path) + File.separator + SaveAsProject.this.project.getName() + ".udig";
                String destinationProject = String.valueOf(destinationUdigFolder) + File.separator + file.getName();
                File dest = new File(destinationUdigFolder);
                if (dest.exists()) {
                    boolean isOk = MessageDialog.openConfirm((Shell)shell, (String)Messages.SaveProject_Export, (String)Messages.SaveProject_Overwrite);
                    if (isOk) {
                        try {
                            FileUtils.deleteDirectory((File)dest);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        return;
                    }
                }
                if (path != null && path.length() > 0) {
                    ExportProjectUtils.exportProject(SaveAsProject.this.project, path, ProgressManager.instance().get(null));
                    File destPrj = new File(destinationProject);
                    if (destPrj.exists()) {
                        MessageDialog.openInformation((Shell)shell, (String)Messages.SaveProject_Export, (String)Messages.SaveProject_Success);
                    } else {
                        MessageDialog.openError((Shell)shell, (String)Messages.SaveProject_Export, (String)Messages.SaveProject_Fail);
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : new StructuredSelection();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

