/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.File;
import java.text.MessageFormat;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenProject
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    private volatile Job job;
    private String path;

    public void init(IViewPart view) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IAction action) {
        this.path = null;
        Shell activeShell = Display.getDefault().getActiveShell();
        while (this.path == null) {
            DirectoryDialog dialog = new DirectoryDialog(activeShell);
            dialog.setFilterPath(Messages.OpenProject_newProject_filename);
            dialog.setMessage(Messages.OpenProject_selectProject);
            dialog.setText(Messages.OpenProject_openProject);
            this.path = dialog.open();
            if (this.path == null) {
                return;
            }
            File projFile = new File(String.valueOf(this.path) + File.separator + "project.uprj");
            if (projFile.exists()) continue;
            String message = Messages.OpenProject_ErrorMessage;
            message = MessageFormat.format(message, "project.uprj");
            MessageDialog.openInformation((Shell)activeShell, (String)Messages.OpenProject_ErrorTitle, (String)message);
            this.path = null;
        }
        if (this.job == null) {
            OpenProject openProject = this;
            synchronized (openProject) {
                if (this.job == null) {
                    this.job = new Job(Messages.OpenProject_openProject_title){

                        protected IStatus run(IProgressMonitor monitor) {
                            ProjectPlugin.getPlugin().getProjectRegistry().getProject(OpenProject.this.path);
                            return Status.OK_STATUS;
                        }
                    };
                }
            }
        }
        this.job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

