/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.actions.MapDropAction;
import net.refractions.udig.project.ui.internal.actions.OpenMapAction;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.ViewerDropLocation;
import org.eclipse.core.runtime.IProgressMonitor;

public class OnProjectDropAction
extends IDropAction {
    public boolean accept() {
        if (this.getViewerLocation() == ViewerDropLocation.NONE) {
            return false;
        }
        if (!(this.getDestination() instanceof Project)) {
            return false;
        }
        if (this.isLegalType(this.getData())) {
            return true;
        }
        List<Object> obj = this.toCollection();
        return !obj.isEmpty();
    }

    private List<Object> toCollection() {
        Object[] array = null;
        if (this.getData().getClass().isArray()) {
            array = (Object[])this.getData();
        }
        if (this.getData() instanceof Collection) {
            Collection coll = (Collection)this.getData();
            array = coll.toArray();
        }
        ArrayList<Object> obj = new ArrayList<Object>();
        if (array != null) {
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (this.isLegalType(object)) {
                    obj.add(object);
                }
                ++n2;
            }
        }
        return obj;
    }

    private boolean isLegalType(Object obj) {
        if (obj instanceof IGeoResource) {
            return true;
        }
        if (obj instanceof IResolveFolder) {
            return true;
        }
        return obj instanceof IService;
    }

    public void perform(IProgressMonitor monitor) {
        if (!this.accept()) {
            throw new IllegalStateException("the data or destination is not legal");
        }
        ArrayList<IGeoResource> resources = new ArrayList<IGeoResource>();
        Object data = this.getData();
        if (data instanceof IGeoResource) {
            resources.add((IGeoResource)data);
        } else if (data instanceof IResolveFolder) {
            resources.addAll(MapDropAction.toResources(monitor, data, ((Object)((Object)this)).getClass()));
        } else if (data instanceof IService) {
            resources.addAll(MapDropAction.toResources(monitor, data, ((Object)((Object)this)).getClass()));
        } else {
            if (data instanceof String) {
                new OpenMapAction().loadMapFromString((String)data, null, true);
                return;
            }
            List<Object> list = this.toCollection();
            for (Object object : list) {
                if (object instanceof IGeoResource) {
                    resources.add((IGeoResource)object);
                    continue;
                }
                if (!(object instanceof IService) && !(object instanceof IResolveFolder)) continue;
                Collection<IGeoResource> toResources = MapDropAction.toResources(monitor, object, ((Object)((Object)this)).getClass());
                resources.addAll(toResources);
            }
        }
        ApplicationGIS.createAndOpenMap(resources, (IProject)this.getDestination());
    }
}

