/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.internal.ui.actions.CatalogImportDropAction;
import net.refractions.udig.catalog.ui.workflow.ResourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.internal.impl.LayerResource;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.wizard.MapImport;
import net.refractions.udig.project.ui.internal.wizard.MapImportWizard;
import net.refractions.udig.ui.ViewerDropLocation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class MapDropAction
extends CatalogImportDropAction {
    public boolean accept() {
        Object data2 = this.getData();
        if (data2.getClass().isArray()) {
            Object[] objects;
            Object[] objectArray = objects = (Object[])data2;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (this.canAccept(object)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return this.canAccept(data2);
    }

    private boolean canAccept(Object data2) {
        IAdaptable adaptable;
        if (data2 instanceof LayerResource) {
            LayerImpl layer = ((LayerResource)data2).getLayer();
            if (this.desinationContainsLayer((ILayer)layer)) {
                return false;
            }
            if (this.destinationLayerMapContainsLayer((ILayer)layer)) {
                return false;
            }
        }
        if (data2 instanceof IGeoResource) {
            return true;
        }
        if (data2 instanceof IAdaptable && (adaptable = (IAdaptable)data2).getAdapter(IGeoResource.class) != null) {
            return true;
        }
        if (data2 instanceof IResolve) {
            return true;
        }
        return this.canImport(data2);
    }

    private boolean destinationLayerMapContainsLayer(ILayer layer) {
        ILayer dest;
        return this.getDestination() instanceof ILayer && (dest = (ILayer)this.getDestination()).getMap().getMapLayers().contains(layer);
    }

    private boolean desinationContainsLayer(ILayer layer) {
        IMap map;
        return this.getDestination() instanceof IMap && (map = (IMap)this.getDestination()).getMapLayers().contains(layer);
    }

    public void perform(IProgressMonitor monitor) {
        ArrayList<IGeoResource> resources = new ArrayList<IGeoResource>();
        ArrayList<Object> otherData = new ArrayList<Object>();
        Object data2 = this.getData();
        if (data2.getClass().isArray()) {
            Object[] array = (Object[])data2;
            int i = 0;
            while (i < array.length) {
                Object object = array[i];
                if (this.canAccept(object)) {
                    this.seperateGeoResources(resources, otherData, object);
                }
                ++i;
            }
        } else {
            this.seperateGeoResources(resources, otherData, data2);
        }
        int layerpos = -1;
        layerpos = this.calculateDropPosition();
        IMap map = null;
        if (!otherData.isEmpty()) {
            for (Object e : otherData) {
                Collection<IGeoResource> additionalResources = MapDropAction.toResources(monitor, e, ((Object)((Object)this)).getClass());
                ProjectUIPlugin.trace("net.refractions.udig.project.ui/debug/dnd/trace", MapDropAction.class, "Converted from DnD " + e.getClass().getSimpleName() + " data to:" + additionalResources, null);
                resources.addAll(additionalResources);
            }
        }
        if (!resources.isEmpty()) {
            this.addResourcesToMap(resources, layerpos, map);
        }
    }

    static Collection<IGeoResource> toResources(IProgressMonitor monitor, Object object, Class<?> callingClass) {
        MapImport mapImport = new MapImport(){

            @Override
            protected WorkflowWizard createWorkflowWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
                return new MapImportWizard(workflow, map){

                    @Override
                    protected boolean performFinish(IProgressMonitor monitor) {
                        return true;
                    }
                };
            }
        };
        if (mapImport.run(monitor, object)) {
            ResourceSelectionState state = (ResourceSelectionState)mapImport.getDialog().getWorkflowWizard().getWorkflow().getState(ResourceSelectionState.class);
            Set<IGeoResource> keySet = state.getResources().keySet();
            ProjectUIPlugin.trace("net.refractions.udig.project.ui/debug/dnd/trace", callingClass, "converted " + object + " to " + keySet, null);
            return keySet;
        }
        return Collections.emptyList();
    }

    private void addResourcesToMap(List<IGeoResource> resources, int layerpos, IMap map2) {
        IMap map = map2;
        if (this.getDestination() instanceof Layer) {
            Layer layer = (Layer)this.getDestination();
            map = layer.getMap();
        } else if (this.getDestination() instanceof IMap) {
            map = (IMap)this.getDestination();
        }
        if (map == null) {
            map = ApplicationGIS.getActiveMap();
        }
        if (map == ApplicationGIS.NO_MAP) {
            ProjectUIPlugin.trace("net.refractions.udig.project.ui/debug/dnd/trace", ((Object)((Object)this)).getClass(), "Creating new Map with from resources: " + resources, null);
            ApplicationGIS.addLayersToMap(null, resources, layerpos);
        } else {
            ProjectUIPlugin.trace("net.refractions.udig.project.ui/debug/dnd/trace", ((Object)((Object)this)).getClass(), "Add layers to " + map.getName() + " from resources: " + resources, null);
            ApplicationGIS.addLayersToMap(map, resources, layerpos, null, true);
        }
    }

    private void seperateGeoResources(List<IGeoResource> resources, List<Object> otherData, Object object) {
        if (object instanceof IGeoResource) {
            resources.add((IGeoResource)object);
        } else {
            Object processed = this.processDropItem(object);
            otherData.add(processed);
        }
    }

    private int calculateDropPosition() {
        int layerpos = -1;
        if (this.getDestination() instanceof ILayer) {
            ILayer target = (ILayer)this.getDestination();
            ViewerDropLocation location = this.getViewerLocation();
            layerpos = target.getZorder();
            if (location == ViewerDropLocation.NONE) {
                layerpos = 0;
            }
            if (location == ViewerDropLocation.BEFORE) {
                ++layerpos;
            }
            if (location == ViewerDropLocation.ON) {
                ++layerpos;
            }
        }
        return layerpos;
    }

    private Object processDropItem(Object concreteData2) {
        URL url;
        Object concreteData = concreteData2;
        if (concreteData instanceof String && (url = this.extractURL((String)concreteData)) != null) {
            concreteData = url;
        }
        return concreteData;
    }
}

