/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.util.Collection;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.dragdrop.MoveLayerDropAction;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.ViewerDropLocation;
import org.eclipse.core.runtime.IProgressMonitor;

public class LayerDropAction
extends IDropAction {
    public boolean accept() {
        Collection<Layer> layers = MoveLayerDropAction.toCollection(this.getData());
        if (!(this.getDestination() instanceof Layer) && !(this.getData() instanceof Layer) && layers.isEmpty()) {
            return false;
        }
        Layer destination2 = (Layer)this.getDestination();
        for (Layer layer : layers) {
            if (layer == destination2 && this.getViewerLocation() != ViewerDropLocation.NONE) {
                return false;
            }
            if (destination2.getMap() == layer.getMap()) continue;
            return false;
        }
        return true;
    }

    public void perform(IProgressMonitor monitor) {
        Layer target = (Layer)this.getDestination();
        Collection<Layer> layers = MoveLayerDropAction.toCollection(this.getData());
        for (Layer layer : layers) {
            int i;
            ViewerDropLocation location = this.getViewerLocation();
            if (location == ViewerDropLocation.NONE) {
                layer.setZorder(0);
                continue;
            }
            if (Math.abs(layer.getZorder() - target.getZorder()) == 1) {
                int tmp = layer.getZorder();
                layer.setZorder(target.getZorder());
                target.setZorder(tmp);
                continue;
            }
            if (location == ViewerDropLocation.BEFORE) {
                i = target.getZorder();
                if (layer.getZorder() > target.getZorder()) {
                    ++i;
                }
                if (i > layer.getMap().getMapLayers().size()) {
                    layer.setZorder(layer.getMap().getMapLayers().size());
                    continue;
                }
                if (layer.equals(target)) continue;
                layer.setZorder(i);
                continue;
            }
            if (location == ViewerDropLocation.ON) {
                i = target.getZorder();
                if (layer.equals(target)) continue;
                layer.setZorder(i);
                continue;
            }
            i = target.getZorder();
            if (layer.getZorder() < target.getZorder()) {
                --i;
            }
            if (i < 0) {
                i = 0;
            }
            layer.setZorder(i);
        }
    }
}

