/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.LayersView;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.ui.IDropAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.widgets.Control;

public class DropMap
extends IDropAction {
    public boolean accept() {
        File file;
        if (this.getDestination() instanceof ILayer) {
            if (this.getEvent() == null) {
                return false;
            }
            Control control = ((DropTarget)this.getEvent().widget).getControl();
            if (control != LayersView.getViewer().getControl() && !(control instanceof ViewportPane)) {
                return false;
            }
        }
        if (this.getData() instanceof IProjectElement) {
            return true;
        }
        if (this.getData() instanceof EObject && !(this.getDestination() instanceof ILayer)) {
            EObject eobj = (EObject)this.getData();
            while (eobj != null && !(eobj instanceof IProjectElement)) {
                eobj = eobj.eContainer();
            }
            if (eobj == null) {
                return false;
            }
            if (this.getData() instanceof ILayer && this.getDestination() instanceof LayersView && ApplicationGIS.getActiveMap() != ApplicationGIS.NO_MAP) {
                return false;
            }
            return !(this.getData() instanceof ILayer) || !(this.getDestination() instanceof MapEditorPart);
        }
        URL url = null;
        if (this.getData() instanceof String) {
            String string = (String)this.getData();
            try {
                string = URLDecoder.decode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            try {
                url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {}
            if (url == null && !(file = new File(string)).exists()) {
                return false;
            }
        }
        if (this.getData() instanceof URL) {
            url = (URL)this.getData();
        }
        if (url != null) {
            String fileString = url.getFile();
            try {
                file = new File(fileString);
                return file.exists() && fileString.endsWith(".umap");
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public void perform(IProgressMonitor monitor) {
        File file;
        URL url;
        block17: {
            block19: {
                block18: {
                    if (this.getData() instanceof EObject && !(this.getDestination() instanceof ILayer)) {
                        EObject eobj = (EObject)this.getData();
                        while (eobj != null && !(eobj instanceof IProjectElement)) {
                            eobj = eobj.eContainer();
                        }
                        ApplicationGIS.openProjectElement((IProjectElement)eobj, false);
                    }
                    url = null;
                    if (!(this.getData() instanceof IProjectElement)) break block18;
                    ApplicationGIS.openProjectElement((IProjectElement)this.getData(), false);
                    break block17;
                }
                if (!(this.getData() instanceof String)) break block19;
                String string = (String)this.getData();
                try {
                    string = URLDecoder.decode(string, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                try {
                    url = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    file = new File(string);
                    if (!file.exists()) break block17;
                    try {
                        url = file.toURL();
                        break block17;
                    }
                    catch (MalformedURLException malformedURLException2) {}
                }
                break block17;
            }
            if (this.getData() instanceof URL) {
                url = (URL)this.getData();
            }
        }
        if (url != null) {
            try {
                String fileString = url.getFile();
                file = new File(fileString);
                if (!file.exists() || !fileString.endsWith(".umap")) {
                    ProjectUIPlugin.log("Some how accept() accepted: " + this.getData(), new Exception());
                    return;
                }
            }
            catch (Exception exception) {
                ProjectUIPlugin.log("Some how accept() accepted: " + this.getData(), new Exception());
                return;
            }
            try {
                IProjectElement elem = ApplicationGIS.loadProjectElement(url, ApplicationGIS.getActiveProject());
                if (elem instanceof IProjectElement) {
                    ApplicationGIS.openProjectElement(elem, false);
                }
            }
            catch (IllegalArgumentException e) {
                ProjectPlugin.log((String)"", (Throwable)e);
            }
            catch (IOException e) {
                ProjectPlugin.log((String)"", (Throwable)e);
            }
        }
    }
}

